/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics;

public class GeomUtils {
    protected static double distTolerance = 1.0E-5;
    protected static double angleTolerance = 4.84813681109536E-11;
    protected static double areaTolerance = 1.0E-10;

    public static final double getDistTolerance() {
        return distTolerance;
    }

    public static final void setDistTolerance(double distTolerance) {
        GeomUtils.distTolerance = distTolerance;
    }

    public static final double getAngleTolerance() {
        return angleTolerance;
    }

    public static final void setAngleTolerance(double angleTolerance) {
        GeomUtils.angleTolerance = angleTolerance;
    }

    public static double getAreaTolerance() {
        return areaTolerance;
    }

    public static void setAreaTolerance(double areaTolerance) {
        GeomUtils.areaTolerance = areaTolerance;
    }

    static final boolean arePointsCollinear(double ax, double ay, double bx, double by, double cx, double cy) {
        double dx1 = bx - ax;
        double dy2 = cy - ay;
        double dx2 = cx - ax;
        double dy1 = by - ay;
        double crossProd = dx1 * dy2 - dx2 * dy1;
        if (crossProd < 0.0) {
            crossProd = -crossProd;
        }
        return crossProd <= areaTolerance;
    }

    static final boolean lineSeparatesPoints(double startx, double starty, double endx, double endy, double p0x, double p0y, double p1x, double p1y, boolean strict) {
        double dx = endx - startx;
        double dy = endy - starty;
        double d0x = p0x - startx;
        double d0y = p0y - starty;
        double d1x = p1x - startx;
        double d1y = p1y - starty;
        double dotProd0 = dx * d0y - dy * d0x;
        double dotProd1 = dx * d1y - dy * d1x;
        double sgn = Math.signum(dotProd0) * Math.signum(dotProd1);
        return strict ? sgn < 0.0 : sgn <= 0.0;
    }
}

