/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.bezier.flatnessalgos;

import com.caffeineowl.graphics.DistUtils;
import com.caffeineowl.graphics.bezier.CubicFlatnessAlgorithm;
import com.caffeineowl.graphics.bezier.QuadFlatnessAlgorithm;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;

public class ConvexHullFlatnessAlgo
implements QuadFlatnessAlgorithm,
CubicFlatnessAlgorithm {
    public final boolean isDegenerationRobust() {
        return true;
    }

    public final boolean isSquaredFlatenessPreferred() {
        return true;
    }

    public final double getFlatness(QuadCurve2D curve) {
        return Math.sqrt(this.getSquaredFlatness(curve));
    }

    public final double getSquaredFlatness(QuadCurve2D curve) {
        return DistUtils.pointToSegSqEucDist(curve.getCtrlX(), curve.getCtrlY(), curve.getX1(), curve.getY1(), curve.getX2(), curve.getY2());
    }

    public final double getFlatness(CubicCurve2D curve) {
        return Math.sqrt(this.getSquaredFlatness(curve));
    }

    public final double getSquaredFlatness(CubicCurve2D curve) {
        double sqDist2;
        double sx = curve.getX1();
        double sy = curve.getY1();
        double ex = curve.getX2();
        double ey = curve.getY2();
        double sqDist1 = DistUtils.pointToSegSqEucDist(curve.getCtrlX1(), curve.getCtrlY1(), sx, sy, ex, ey);
        return sqDist1 > (sqDist2 = DistUtils.pointToSegSqEucDist(curve.getCtrlX2(), curve.getCtrlY2(), sx, sy, ex, ey)) ? sqDist1 : sqDist2;
    }
}

