/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.groups;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.groups.Blast;
import com.flickr4java.flickr.groups.Category;
import com.flickr4java.flickr.groups.Group;
import com.flickr4java.flickr.groups.GroupList;
import com.flickr4java.flickr.groups.Restriction;
import com.flickr4java.flickr.groups.Subcategory;
import com.flickr4java.flickr.groups.Throttle;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GroupsInterface {
    private static Logger _log = Logger.getLogger(GroupsInterface.class);
    public static final String METHOD_BROWSE = "flickr.groups.browse";
    public static final String METHOD_GET_ACTIVE_LIST = "flickr.groups.getActiveList";
    public static final String METHOD_GET_INFO = "flickr.groups.getInfo";
    public static final String METHOD_SEARCH = "flickr.groups.search";
    public static final String METHOD_JOIN = "flickr.groups.join";
    public static final String METHOD_JOIN_REQUEST = "flickr.groups.joinRequest";
    public static final String METHOD_LEAVE = "flickr.groups.leave";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;

    public GroupsInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    @Deprecated
    public Category browse(String catId) throws FlickrException {
        Response response;
        ArrayList<Subcategory> subcategories = new ArrayList<Subcategory>();
        ArrayList<Group> groups = new ArrayList<Group>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_BROWSE);
        if (catId != null) {
            parameters.put("cat_id", catId);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element categoryElement = response.getPayload();
        Category category = new Category();
        category.setName(categoryElement.getAttribute("name"));
        category.setPath(categoryElement.getAttribute("path"));
        category.setPathIds(categoryElement.getAttribute("pathids"));
        NodeList subcatNodes = categoryElement.getElementsByTagName("subcat");
        for (int i = 0; i < subcatNodes.getLength(); ++i) {
            Element node = (Element)subcatNodes.item(i);
            Subcategory subcategory = new Subcategory();
            subcategory.setId(Integer.parseInt(node.getAttribute("id")));
            subcategory.setName(node.getAttribute("name"));
            subcategory.setCount(Integer.parseInt(node.getAttribute("count")));
            subcategories.add(subcategory);
        }
        NodeList groupNodes = categoryElement.getElementsByTagName("group");
        for (int i = 0; i < groupNodes.getLength(); ++i) {
            Element node = (Element)groupNodes.item(i);
            Group group = new Group();
            group.setId(node.getAttribute("nsid"));
            group.setName(node.getAttribute("name"));
            group.setMembers(node.getAttribute("members"));
            groups.add(group);
        }
        category.setGroups(groups);
        category.setSubcategories(subcategories);
        return category;
    }

    public Group getInfo(String groupId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_INFO);
        parameters.put("group_id", groupId);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element groupElement = response.getPayload();
        Group group = new Group();
        group.setId(groupElement.getAttribute("id"));
        group.setIconFarm(groupElement.getAttribute("iconfarm"));
        group.setIconServer(groupElement.getAttribute("iconserver"));
        group.setLang(groupElement.getAttribute("lang"));
        group.setPoolModerated(!groupElement.getAttribute("ispoolmoderated").equals("0"));
        group.setName(XMLUtilities.getChildValue(groupElement, "name"));
        group.setDescription(XMLUtilities.getChildValue(groupElement, "description"));
        group.setMembers(XMLUtilities.getChildValue(groupElement, "members"));
        group.setPrivacy(XMLUtilities.getChildValue(groupElement, "privacy"));
        group.setPoolCount(XMLUtilities.getChildValue(groupElement, "pool_count"));
        group.setTopicCount(XMLUtilities.getChildValue(groupElement, "topic_count"));
        NodeList throttleNodes = groupElement.getElementsByTagName("throttle");
        int n = throttleNodes.getLength();
        if (n == 1) {
            Element throttleElement = (Element)throttleNodes.item(0);
            Throttle throttle = new Throttle();
            group.setThrottle(throttle);
            throttle.setMode(throttleElement.getAttribute("mode"));
            String countStr = throttleElement.getAttribute("count");
            String remainingStr = throttleElement.getAttribute("remaining");
            if (countStr != null && countStr.length() > 0) {
                throttle.setCount(Integer.parseInt(countStr));
            }
            if (remainingStr != null && remainingStr.length() > 0) {
                throttle.setRemaining(Integer.parseInt(remainingStr));
            }
        } else if (n > 1) {
            _log.warn("WARNING: more than one throttle element in group");
        }
        NodeList restrictionNodes = groupElement.getElementsByTagName("restrictions");
        n = restrictionNodes.getLength();
        if (n == 1) {
            Element restrictionElement = (Element)restrictionNodes.item(0);
            Restriction restriction = new Restriction();
            group.setRestriction(restriction);
            restriction.setIsPhotosOk("1".equals(restrictionElement.getAttribute("photos_ok")));
            restriction.setIsVideosOk("1".equals(restrictionElement.getAttribute("videos_ok")));
            restriction.setIsImagesOk("1".equals(restrictionElement.getAttribute("images_ok")));
            restriction.setIsScreensOk("1".equals(restrictionElement.getAttribute("screens_ok")));
            restriction.setIsArtOk("1".equals(restrictionElement.getAttribute("art_ok")));
            restriction.setIsSafeOk("1".equals(restrictionElement.getAttribute("safe_ok")));
            restriction.setIsModerateOk("1".equals(restrictionElement.getAttribute("moderate_ok")));
            restriction.setIsRestrictedOk("1".equals(restrictionElement.getAttribute("restricted_ok")));
            restriction.setIsHasGeo("1".equals(restrictionElement.getAttribute("has_geo")));
        } else if (n > 1) {
            _log.warn("WARNING: more than one throttle element in group");
        }
        NodeList blastNodes = groupElement.getElementsByTagName("blast");
        n = blastNodes.getLength();
        if (n == 1) {
            Element blastElement = (Element)blastNodes.item(0);
            Blast blast = new Blast();
            group.setBlast(blast);
            blast.setUserId(blastElement.getAttribute("user_id"));
            blast.setDateBlastAdded(blastElement.getAttribute("date_blast_added"));
            blast.setBlast(XMLUtilities.getChildValue(groupElement, "blast"));
        } else if (n > 1) {
            _log.warn("WARNING: more than one throttle element in group");
        }
        return group;
    }

    public Collection<Group> search(String text, int perPage, int page) throws FlickrException {
        Response response;
        GroupList<Group> groupList = new GroupList<Group>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SEARCH);
        parameters.put("text", text);
        if (perPage > 0) {
            parameters.put("per_page", String.valueOf(perPage));
        }
        if (page > 0) {
            parameters.put("page", String.valueOf(page));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element groupsElement = response.getPayload();
        NodeList groupNodes = groupsElement.getElementsByTagName("group");
        groupList.setPage(XMLUtilities.getIntAttribute(groupsElement, "page"));
        groupList.setPages(XMLUtilities.getIntAttribute(groupsElement, "pages"));
        groupList.setPerPage(XMLUtilities.getIntAttribute(groupsElement, "perpage"));
        groupList.setTotal(XMLUtilities.getIntAttribute(groupsElement, "total"));
        for (int i = 0; i < groupNodes.getLength(); ++i) {
            Element groupElement = (Element)groupNodes.item(i);
            Group group = new Group();
            group.setId(groupElement.getAttribute("nsid"));
            group.setName(groupElement.getAttribute("name"));
            groupList.add(group);
        }
        return groupList;
    }

    public void join(String groupId, Boolean acceptRules) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_JOIN);
        parameters.put("group_id", groupId);
        if (acceptRules != null) {
            parameters.put("accept_rules", acceptRules);
        }
        if ((response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void joinRequest(String groupId, String message, boolean acceptRules) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_JOIN_REQUEST);
        parameters.put("group_id", groupId);
        parameters.put("message", message);
        parameters.put("accept_rules", acceptRules);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void leave(String groupId, Boolean deletePhotos) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_LEAVE);
        parameters.put("group_id", groupId);
        parameters.put("delete_photos", deletePhotos);
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }
}

