/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.DataOutputStream;
import com.jmatio.types.MLArray;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

class FileBufferedDataOutputStream
extends OutputStream
implements DataOutputStream {
    private static final int BUFFER_SIZE = 1024;
    private ByteBuffer buf;
    private final FileChannel rwChannel;
    private final RandomAccessFile raFile;
    private final File file;

    public FileBufferedDataOutputStream() throws IOException {
        this.file = File.createTempFile("jmatio-", null);
        this.file.deleteOnExit();
        this.raFile = new RandomAccessFile(this.file, "rw");
        this.rwChannel = this.raFile.getChannel();
        this.buf = ByteBuffer.allocate(1024);
    }

    public FileBufferedDataOutputStream(MLArray array) throws IOException {
        this.file = File.createTempFile("jmatio-" + array.getName() + "-", null);
        this.file.deleteOnExit();
        this.raFile = new RandomAccessFile(this.file, "rw");
        this.rwChannel = this.raFile.getChannel();
        this.buf = ByteBuffer.allocate(1024);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buf.position() >= this.buf.capacity()) {
            this.flush();
        }
        this.buf.put((byte)(b & 0xFF));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int wbytes = len;
        int offset = off;
        while (wbytes > 0) {
            if (this.buf.position() >= this.buf.capacity()) {
                this.flush();
            }
            int length = Math.min(wbytes, this.buf.limit() - this.buf.position());
            this.buf.put(b, offset, length);
            offset += length;
            wbytes -= length;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.buf = null;
        if (this.rwChannel.isOpen()) {
            this.rwChannel.close();
        }
        this.raFile.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.buf != null && this.buf.position() > 0) {
            this.buf.flip();
            this.rwChannel.write(this.buf);
            this.buf.clear();
        }
    }

    @Override
    public int size() throws IOException {
        this.flush();
        return (int)this.file.length();
    }

    @Override
    public ByteBuffer getByteBuffer() throws IOException {
        return this.rwChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.file.length());
    }

    @Override
    public void write(ByteBuffer byteBuffer) throws IOException {
        byte[] tmp = new byte[1024];
        while (byteBuffer.hasRemaining()) {
            int length = Math.min(byteBuffer.remaining(), tmp.length);
            byteBuffer.get(tmp, 0, length);
            this.write(tmp, 0, length);
        }
    }
}

