/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;

public class MLInt32
extends MLNumericArray<Integer> {
    public MLInt32(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLInt32(String name, int[] dims) {
        super(name, dims, 12, 0);
    }

    public MLInt32(String name, Integer[] vals, int m) {
        super(name, 12, (Number[])vals, m);
    }

    public MLInt32(String name, int[][] vals) {
        this(name, MLInt32.int2DToInteger(vals), vals.length);
    }

    public MLInt32(String name, int[] vals, int m) {
        this(name, MLInt32.castToInteger(vals), m);
    }

    public Integer[] createArray(int m, int n) {
        return new Integer[m * n];
    }

    public int[][] getArray() {
        int[][] result = new int[this.getM()][];
        int m = 0;
        while (m < this.getM()) {
            result[m] = new int[this.getN()];
            int n = 0;
            while (n < this.getN()) {
                result[m][n] = (Integer)this.getReal(m, n);
                ++n;
            }
            ++m;
        }
        return result;
    }

    private static Integer[] castToInteger(int[] d) {
        Integer[] dest = new Integer[d.length];
        int i = 0;
        while (i < d.length) {
            dest[i] = d[i];
            ++i;
        }
        return dest;
    }

    private static Integer[] int2DToInteger(int[][] dd) {
        Integer[] d = new Integer[dd.length * dd[0].length];
        int n = 0;
        while (n < dd[0].length) {
            int m = 0;
            while (m < dd.length) {
                d[m + n * dd.length] = dd[m][n];
                ++m;
            }
            ++n;
        }
        return d;
    }

    @Override
    public Integer buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(bytes).getInt();
    }

    @Override
    public int getBytesAllocated() {
        return 4;
    }

    @Override
    public Class<Integer> getStorageClazz() {
        return Integer.class;
    }

    @Override
    public byte[] getByteArray(Integer value) {
        int byteAllocated = this.getBytesAllocated();
        ByteBuffer buff = ByteBuffer.allocate(byteAllocated);
        buff.putInt(value);
        return buff.array();
    }
}

