/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;

public class MLUInt8
extends MLNumericArray<Byte> {
    public MLUInt8(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLUInt8(String name, int[] dims) {
        super(name, dims, 9, 0);
    }

    public MLUInt8(String name, Byte[] vals, int m) {
        super(name, 9, (Number[])vals, m);
    }

    public MLUInt8(String name, byte[][] vals) {
        this(name, MLUInt8.byte2DToByte(vals), vals.length);
    }

    public MLUInt8(String name, byte[] vals, int m) {
        this(name, MLUInt8.castToByte(vals), m);
    }

    public Byte[] createArray(int m, int n) {
        return new Byte[m * n];
    }

    public byte[][] getArray() {
        byte[][] result = new byte[this.getM()][];
        int m = 0;
        while (m < this.getM()) {
            result[m] = new byte[this.getN()];
            int n = 0;
            while (n < this.getN()) {
                result[m][n] = (Byte)this.getReal(m, n);
                ++n;
            }
            ++m;
        }
        return result;
    }

    private static Byte[] castToByte(byte[] d) {
        Byte[] dest = new Byte[d.length];
        int i = 0;
        while (i < d.length) {
            dest[i] = d[i];
            ++i;
        }
        return dest;
    }

    private static Byte[] byte2DToByte(byte[][] dd) {
        Byte[] d = new Byte[dd.length * dd[0].length];
        int n = 0;
        while (n < dd[0].length) {
            int m = 0;
            while (m < dd.length) {
                d[m + n * dd.length] = dd[m][n];
                ++m;
            }
            ++n;
        }
        return d;
    }

    @Override
    public Byte buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return bytes[0];
    }

    @Override
    public byte[] getByteArray(Byte value) {
        return new byte[]{value};
    }

    @Override
    public int getBytesAllocated() {
        return 1;
    }

    @Override
    public Class<Byte> getStorageClazz() {
        return Byte.class;
    }

    @Override
    protected Byte _get(ByteBuffer buffer, int index) {
        return buffer.get(index);
    }
}

