/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.ICCProfileSanitizer;
import com.twelvemonkeys.lang.Validate;
import java.awt.color.ICC_Profile;
import java.util.Arrays;

final class KCMSSanitizerStrategy
implements ICCProfileSanitizer {
    private static final byte[] CORBIS_RGB_ALTERNATE_XYZ = new byte[]{23, -91, 5, -72};

    KCMSSanitizerStrategy() {
    }

    @Override
    public void fixProfile(ICC_Profile iCC_Profile, byte[] byArray) {
        Validate.notNull(iCC_Profile, "profile");
        if (byArray != null) {
            iCC_Profile.setData(1751474532, byArray);
        }
        if (KCMSSanitizerStrategy.fixProfileXYZTag(iCC_Profile, 0x77747074)) {
            KCMSSanitizerStrategy.fixProfileXYZTag(iCC_Profile, 1918392666);
            KCMSSanitizerStrategy.fixProfileXYZTag(iCC_Profile, 1733843290);
            KCMSSanitizerStrategy.fixProfileXYZTag(iCC_Profile, 1649957210);
        }
    }

    private static boolean fixProfileXYZTag(ICC_Profile iCC_Profile, int n) {
        byte[] byArray = iCC_Profile.getData(n);
        if (byArray != null && Arrays.equals(Arrays.copyOfRange(byArray, 0, 4), CORBIS_RGB_ALTERNATE_XYZ)) {
            byArray[0] = 88;
            byArray[1] = 89;
            byArray[2] = 90;
            byArray[3] = 32;
            iCC_Profile.setData(n, byArray);
            return true;
        }
        return false;
    }
}

