/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.AbstractMetadata;
import com.twelvemonkeys.imageio.plugins.jpeg.AdobeDCT;
import com.twelvemonkeys.imageio.plugins.jpeg.Application;
import com.twelvemonkeys.imageio.plugins.jpeg.Comment;
import com.twelvemonkeys.imageio.plugins.jpeg.Frame;
import com.twelvemonkeys.imageio.plugins.jpeg.Scan;
import com.twelvemonkeys.imageio.plugins.jpeg.Segment;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

class JPEGImage10Metadata
extends AbstractMetadata {
    private final List<Segment> segments;

    JPEGImage10Metadata(List<Segment> list) {
        super(true, "javax_imageio_jpeg_image_1.0", null, null, null);
        this.segments = list;
    }

    @Override
    protected Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("javax_imageio_jpeg_image_1.0");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("JPEGvariety");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("markerSequence");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        block8: for (Segment segment : this.segments) {
            switch (segment.marker) {
                case 65475: {
                    Object object;
                    Frame frame = (Frame)segment;
                    IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("sof");
                    iIOMetadataNode4.setAttribute("process", String.valueOf(frame.marker & 0xF));
                    iIOMetadataNode4.setAttribute("samplePrecision", String.valueOf(frame.samplePrecision));
                    iIOMetadataNode4.setAttribute("numLines", String.valueOf(frame.lines));
                    iIOMetadataNode4.setAttribute("samplesPerLine", String.valueOf(frame.samplesPerLine));
                    iIOMetadataNode4.setAttribute("numFrameComponents", String.valueOf(frame.componentsInFrame()));
                    for (Frame.Component component : frame.components) {
                        object = new IIOMetadataNode("componentSpec");
                        ((IIOMetadataNode)object).setAttribute("componentId", String.valueOf(component.id));
                        ((IIOMetadataNode)object).setAttribute("HsamplingFactor", String.valueOf(component.hSub));
                        ((IIOMetadataNode)object).setAttribute("VsamplingFactor", String.valueOf(component.vSub));
                        ((IIOMetadataNode)object).setAttribute("QtableSelector", String.valueOf(component.qtSel));
                        iIOMetadataNode4.appendChild((Node)object);
                    }
                    iIOMetadataNode3.appendChild(iIOMetadataNode4);
                    continue block8;
                }
                case 65476: {
                    Object object;
                    Frame.Component[] componentArray = (Frame.Component[])segment;
                    IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("dht");
                    for (int i = 0; i < 4; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            if (componentArray.tc[i][j] == 0) continue;
                            object = new IIOMetadataNode("dhtable");
                            ((IIOMetadataNode)object).setAttribute("class", String.valueOf(j));
                            ((IIOMetadataNode)object).setAttribute("htableId", String.valueOf(i));
                            iIOMetadataNode5.appendChild((Node)object);
                        }
                    }
                    iIOMetadataNode3.appendChild(iIOMetadataNode5);
                    continue block8;
                }
                case 65499: {
                    iIOMetadataNode3.appendChild(new IIOMetadataNode("dqt"));
                    continue block8;
                }
                case 65498: {
                    Scan scan = (Scan)segment;
                    IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("sos");
                    iIOMetadataNode6.setAttribute("numScanComponents", String.valueOf(scan.components.length));
                    iIOMetadataNode6.setAttribute("startSpectralSelection", String.valueOf(scan.spectralSelStart));
                    iIOMetadataNode6.setAttribute("endSpectralSelection", String.valueOf(scan.spectralSelEnd));
                    iIOMetadataNode6.setAttribute("approxHigh", String.valueOf(scan.approxHigh));
                    iIOMetadataNode6.setAttribute("approxLow", String.valueOf(scan.approxLow));
                    for (Scan.Component component : scan.components) {
                        IIOMetadataNode iIOMetadataNode7 = new IIOMetadataNode("scanComponentSpec");
                        iIOMetadataNode7.setAttribute("componentSelector", String.valueOf(component.scanCompSel));
                        iIOMetadataNode7.setAttribute("dcHuffTable", String.valueOf(component.dcTabSel));
                        iIOMetadataNode7.setAttribute("acHuffTable", String.valueOf(component.acTabSel));
                        iIOMetadataNode6.appendChild(iIOMetadataNode7);
                    }
                    iIOMetadataNode3.appendChild(iIOMetadataNode6);
                    continue block8;
                }
                case 65534: {
                    Object object = new IIOMetadataNode("com");
                    ((IIOMetadataNode)object).setAttribute("comment", ((Comment)segment).comment);
                    iIOMetadataNode3.appendChild((Node)object);
                    continue block8;
                }
                case 65518: {
                    if (!(segment instanceof AdobeDCT)) break;
                    AdobeDCT adobeDCT = (AdobeDCT)segment;
                    IIOMetadataNode iIOMetadataNode8 = new IIOMetadataNode("app14Adobe");
                    iIOMetadataNode8.setAttribute("version", String.valueOf(adobeDCT.version));
                    iIOMetadataNode8.setAttribute("flags0", String.valueOf(adobeDCT.flags0));
                    iIOMetadataNode8.setAttribute("flags1", String.valueOf(adobeDCT.flags1));
                    iIOMetadataNode8.setAttribute("transform", String.valueOf(adobeDCT.transform));
                    iIOMetadataNode3.appendChild(iIOMetadataNode8);
                    continue block8;
                }
            }
            IIOMetadataNode iIOMetadataNode9 = new IIOMetadataNode("unknown");
            iIOMetadataNode9.setAttribute("MarkerTag", String.valueOf(segment.marker & 0xFF));
            iIOMetadataNode9.setUserObject(((Application)segment).data);
            iIOMetadataNode3.appendChild(iIOMetadataNode9);
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        for (Segment segment : this.segments) {
            if (!(segment instanceof Frame)) continue;
            Frame frame = (Frame)segment;
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
            iIOMetadataNode2.setAttribute("name", frame.componentsInFrame() == 1 ? "Gray" : "RGB");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
            iIOMetadataNode3.setAttribute("value", String.valueOf(frame.componentsInFrame()));
            iIOMetadataNode.appendChild(iIOMetadataNode3);
            break;
        }
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", "JPEG");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Lossless");
        iIOMetadataNode3.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("NumProgressiveScans");
        iIOMetadataNode4.setAttribute("value", "1");
        iIOMetadataNode.appendChild(iIOMetadataNode4);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
        for (Segment segment : this.segments) {
            if (!(segment instanceof Comment)) continue;
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", "comment");
            iIOMetadataNode2.setAttribute("value", ((Comment)segment).comment);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode.hasChildNodes() ? iIOMetadataNode : null;
    }
}

