/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageWriterSpi;
import com.twelvemonkeys.imageio.util.ProgressListenerBase;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;

public class JPEGImageWriter
extends ImageWriterBase {
    private final ImageWriter delegate;
    private final ProgressDelegator progressDelegator;

    public JPEGImageWriter(JPEGImageWriterSpi jPEGImageWriterSpi, ImageWriter imageWriter) {
        super(jPEGImageWriterSpi);
        this.delegate = imageWriter;
        this.progressDelegator = new ProgressDelegator();
    }

    private void installListeners() {
        this.delegate.addIIOWriteProgressListener(this.progressDelegator);
        this.delegate.addIIOWriteWarningListener(this.progressDelegator);
    }

    @Override
    protected void resetMembers() {
        this.installListeners();
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
        this.delegate.setOutput(object);
    }

    @Override
    public Object getOutput() {
        return this.delegate.getOutput();
    }

    @Override
    public Locale[] getAvailableLocales() {
        return this.delegate.getAvailableLocales();
    }

    @Override
    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
    }

    @Override
    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return this.delegate.getDefaultWriteParam();
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return this.delegate.getDefaultStreamMetadata(imageWriteParam);
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return this.delegate.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return this.delegate.convertStreamMetadata(iIOMetadata, imageWriteParam);
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return this.delegate.convertImageMetadata(iIOMetadata, imageTypeSpecifier, imageWriteParam);
    }

    @Override
    public int getNumThumbnailsSupported(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return this.delegate.getNumThumbnailsSupported(imageTypeSpecifier, imageWriteParam, iIOMetadata, iIOMetadata2);
    }

    @Override
    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return this.delegate.getPreferredThumbnailSizes(imageTypeSpecifier, imageWriteParam, iIOMetadata, iIOMetadata2);
    }

    @Override
    public boolean canWriteRasters() {
        return this.delegate.canWriteRasters();
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.write(iIOMetadata, iIOImage, imageWriteParam);
    }

    @Override
    public void write(IIOImage iIOImage) throws IOException {
        this.delegate.write(iIOImage);
    }

    @Override
    public void write(RenderedImage renderedImage) throws IOException {
        this.delegate.write(renderedImage);
    }

    @Override
    public boolean canWriteSequence() {
        return this.delegate.canWriteSequence();
    }

    @Override
    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        this.delegate.prepareWriteSequence(iIOMetadata);
    }

    @Override
    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.writeToSequence(iIOImage, imageWriteParam);
    }

    @Override
    public void endWriteSequence() throws IOException {
        this.delegate.endWriteSequence();
    }

    @Override
    public boolean canReplaceStreamMetadata() throws IOException {
        return this.delegate.canReplaceStreamMetadata();
    }

    @Override
    public void replaceStreamMetadata(IIOMetadata iIOMetadata) throws IOException {
        this.delegate.replaceStreamMetadata(iIOMetadata);
    }

    @Override
    public boolean canReplaceImageMetadata(int n) throws IOException {
        return this.delegate.canReplaceImageMetadata(n);
    }

    @Override
    public void replaceImageMetadata(int n, IIOMetadata iIOMetadata) throws IOException {
        this.delegate.replaceImageMetadata(n, iIOMetadata);
    }

    @Override
    public boolean canInsertImage(int n) throws IOException {
        return this.delegate.canInsertImage(n);
    }

    @Override
    public void writeInsert(int n, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.writeInsert(n, iIOImage, imageWriteParam);
    }

    @Override
    public boolean canRemoveImage(int n) throws IOException {
        return this.delegate.canRemoveImage(n);
    }

    @Override
    public void removeImage(int n) throws IOException {
        this.delegate.removeImage(n);
    }

    @Override
    public boolean canWriteEmpty() throws IOException {
        return this.delegate.canWriteEmpty();
    }

    @Override
    public void prepareWriteEmpty(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, int n, int n2, IIOMetadata iIOMetadata2, List<? extends BufferedImage> list, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.prepareWriteEmpty(iIOMetadata, imageTypeSpecifier, n, n2, iIOMetadata2, list, imageWriteParam);
    }

    @Override
    public void endWriteEmpty() throws IOException {
        this.delegate.endWriteEmpty();
    }

    @Override
    public boolean canInsertEmpty(int n) throws IOException {
        return this.delegate.canInsertEmpty(n);
    }

    @Override
    public void prepareInsertEmpty(int n, ImageTypeSpecifier imageTypeSpecifier, int n2, int n3, IIOMetadata iIOMetadata, List<? extends BufferedImage> list, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.prepareInsertEmpty(n, imageTypeSpecifier, n2, n3, iIOMetadata, list, imageWriteParam);
    }

    @Override
    public void endInsertEmpty() throws IOException {
        this.delegate.endInsertEmpty();
    }

    @Override
    public boolean canReplacePixels(int n) throws IOException {
        return this.delegate.canReplacePixels(n);
    }

    @Override
    public void prepareReplacePixels(int n, Rectangle rectangle) throws IOException {
        this.delegate.prepareReplacePixels(n, rectangle);
    }

    @Override
    public void replacePixels(RenderedImage renderedImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.replacePixels(renderedImage, imageWriteParam);
    }

    @Override
    public void replacePixels(Raster raster, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.replacePixels(raster, imageWriteParam);
    }

    @Override
    public void endReplacePixels() throws IOException {
        this.delegate.endReplacePixels();
    }

    @Override
    public void abort() {
        super.abort();
        this.delegate.abort();
    }

    @Override
    public void reset() {
        super.reset();
        this.delegate.reset();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.delegate.dispose();
    }

    private class ProgressDelegator
    extends ProgressListenerBase
    implements IIOWriteWarningListener {
        private ProgressDelegator() {
        }

        @Override
        public void imageComplete(ImageWriter imageWriter) {
            JPEGImageWriter.this.processImageComplete();
        }

        @Override
        public void imageProgress(ImageWriter imageWriter, float f) {
            JPEGImageWriter.this.processImageProgress(f);
        }

        @Override
        public void imageStarted(ImageWriter imageWriter, int n) {
            JPEGImageWriter.this.processImageStarted(n);
        }

        @Override
        public void thumbnailComplete(ImageWriter imageWriter) {
            JPEGImageWriter.this.processThumbnailComplete();
        }

        @Override
        public void thumbnailProgress(ImageWriter imageWriter, float f) {
            JPEGImageWriter.this.processThumbnailProgress(f);
        }

        @Override
        public void thumbnailStarted(ImageWriter imageWriter, int n, int n2) {
            JPEGImageWriter.this.processThumbnailStarted(n, n2);
        }

        @Override
        public void writeAborted(ImageWriter imageWriter) {
            JPEGImageWriter.this.processWriteAborted();
        }

        @Override
        public void warningOccurred(ImageWriter imageWriter, int n, String string) {
            JPEGImageWriter.this.processWarningOccurred(n, string);
        }
    }
}

