/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageWriter;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageWriterSpiBase;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.Validate;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;

public class JPEGImageWriterSpi
extends ImageWriterSpiBase {
    private ImageWriterSpi delegateProvider;

    public JPEGImageWriterSpi() {
        super(new JPEGProviderInfo());
    }

    protected JPEGImageWriterSpi(ImageWriterSpi imageWriterSpi) {
        this();
        this.delegateProvider = Validate.notNull(imageWriterSpi);
    }

    static ImageWriterSpi lookupDelegateProvider(ServiceRegistry serviceRegistry) {
        Iterator<ImageWriterSpi> iterator = serviceRegistry.getServiceProviders(ImageWriterSpi.class, true);
        while (iterator.hasNext()) {
            ImageWriterSpi imageWriterSpi = iterator.next();
            if (!imageWriterSpi.getClass().getName().equals("com.sun.imageio.plugins.jpeg.JPEGImageWriterSpi")) continue;
            return imageWriterSpi;
        }
        return null;
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (this.delegateProvider == null) {
            this.delegateProvider = JPEGImageWriterSpi.lookupDelegateProvider(serviceRegistry);
        }
        if (this.delegateProvider != null) {
            serviceRegistry.setOrdering(clazz, this, this.delegateProvider);
        } else {
            IIOUtil.deregisterProvider(serviceRegistry, this, clazz);
        }
    }

    @Override
    public String getVendorName() {
        return String.format("%s/%s", super.getVendorName(), this.delegateProvider.getVendorName());
    }

    @Override
    public String getVersion() {
        return String.format("%s/%s", super.getVersion(), this.delegateProvider.getVersion());
    }

    @Override
    public ImageWriter createWriterInstance(Object object) throws IOException {
        return new JPEGImageWriter(this, this.delegateProvider.createWriterInstance(object));
    }

    @Override
    public String[] getFormatNames() {
        return this.delegateProvider.getFormatNames();
    }

    @Override
    public String[] getFileSuffixes() {
        return this.delegateProvider.getFileSuffixes();
    }

    @Override
    public String[] getMIMETypes() {
        return this.delegateProvider.getMIMETypes();
    }

    @Override
    public boolean isStandardStreamMetadataFormatSupported() {
        return this.delegateProvider.isStandardStreamMetadataFormatSupported();
    }

    @Override
    public String getNativeStreamMetadataFormatName() {
        return this.delegateProvider.getNativeStreamMetadataFormatName();
    }

    @Override
    public String[] getExtraStreamMetadataFormatNames() {
        return this.delegateProvider.getExtraStreamMetadataFormatNames();
    }

    @Override
    public boolean isStandardImageMetadataFormatSupported() {
        return this.delegateProvider.isStandardImageMetadataFormatSupported();
    }

    @Override
    public String getNativeImageMetadataFormatName() {
        return this.delegateProvider.getNativeImageMetadataFormatName();
    }

    @Override
    public String[] getExtraImageMetadataFormatNames() {
        return this.delegateProvider.getExtraImageMetadataFormatNames();
    }

    @Override
    public IIOMetadataFormat getStreamMetadataFormat(String string) {
        return this.delegateProvider.getStreamMetadataFormat(string);
    }

    @Override
    public IIOMetadataFormat getImageMetadataFormat(String string) {
        return this.delegateProvider.getImageMetadataFormat(string);
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        return this.delegateProvider.canEncodeImage(imageTypeSpecifier);
    }

    @Override
    public boolean canEncodeImage(RenderedImage renderedImage) {
        return this.delegateProvider.canEncodeImage(renderedImage);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.delegateProvider.getDescription(locale);
    }

    @Override
    public boolean isFormatLossless() {
        return this.delegateProvider.isFormatLossless();
    }

    public Class[] getOutputTypes() {
        return this.delegateProvider.getOutputTypes();
    }
}

