/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.lang.Validate;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

final class JPEGSegmentImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream stream;
    private final List<Segment> segments = new ArrayList<Segment>(64);
    private int currentSegment = -1;
    private Segment segment;

    JPEGSegmentImageInputStream(ImageInputStream imageInputStream) {
        this.stream = Validate.notNull(imageInputStream, "stream");
    }

    private Segment fetchSegment() throws IOException {
        block15: {
            if (this.currentSegment == -1) {
                this.streamInit();
            } else {
                this.segment = this.segments.get(this.currentSegment);
            }
            if (this.streamPos >= this.segment.end()) {
                int n = this.currentSegment;
                while (++n < this.segments.size()) {
                    this.currentSegment = n;
                    this.segment = this.segments.get(this.currentSegment);
                    if (this.streamPos < this.segment.start || this.streamPos >= this.segment.end()) continue;
                    this.segment.seek(this.stream, this.streamPos);
                    return this.segment;
                }
                this.stream.seek(this.segment.realEnd());
                while (true) {
                    boolean bl;
                    long l = this.stream.getStreamPosition();
                    int n2 = 0;
                    int n3 = this.stream.readUnsignedByte();
                    while (n3 != 255) {
                        n3 = this.stream.readUnsignedByte();
                        ++n2;
                        ++l;
                    }
                    if (n2 != 0) {
                        // empty if block
                    }
                    n3 = 0xFF00 | this.stream.readUnsignedByte();
                    while (n3 == 65535) {
                        ++l;
                        n3 = 0xFF00 | this.stream.readUnsignedByte();
                    }
                    boolean bl2 = JPEGSegmentImageInputStream.isAppSegmentMarker(n3);
                    boolean bl3 = n3 == 65518 && JPEGSegmentImageInputStream.isAppSegmentWithId("Adobe", this.stream);
                    boolean bl4 = bl = n3 == 65505 && JPEGSegmentImageInputStream.isAppSegmentWithId("Exif", this.stream);
                    if (bl2 && !bl && !bl3) {
                        int n4 = this.stream.readUnsignedShort();
                        this.stream.seek(l + 2L + (long)n4);
                        continue;
                    }
                    if (n3 == 65497) {
                        this.segment = new Segment(n3, l, this.segment.end(), 2L);
                        this.segments.add(this.segment);
                    } else {
                        int n5;
                        long l2 = n3 == 65498 ? Long.MAX_VALUE - l : (long)(2 + this.stream.readUnsignedShort());
                        this.segment = bl3 && l2 != 16L ? new AdobeAPP14Replacement(l, this.segment.end(), l2, this.stream) : (n3 == 65499 ? (((n5 = this.stream.read()) & 0x10) == 16 ? new DownsampledDQTReplacement(l, this.segment.end(), l2, n5, this.stream) : new Segment(n3, l, this.segment.end(), l2)) : new Segment(n3, l, this.segment.end(), l2));
                        this.segments.add(this.segment);
                    }
                    this.currentSegment = this.segments.size() - 1;
                    if (this.streamPos >= this.segment.start && this.streamPos < this.segment.end()) {
                        this.segment.seek(this.stream, this.streamPos);
                        break block15;
                    }
                    this.stream.seek(this.segment.realEnd());
                }
            }
            if (this.streamPos < this.segment.start) {
                int n = this.currentSegment;
                while (--n >= 0) {
                    this.currentSegment = n;
                    this.segment = this.segments.get(this.currentSegment);
                    if (this.streamPos < this.segment.start || this.streamPos >= this.segment.end()) continue;
                    this.segment.seek(this.stream, this.streamPos);
                    break;
                }
            } else {
                this.segment.seek(this.stream, this.streamPos);
            }
        }
        return this.segment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAppSegmentWithId(String string, ImageInputStream imageInputStream) throws IOException {
        Validate.notNull(string, "segmentId");
        imageInputStream.mark();
        try {
            int n = imageInputStream.readUnsignedShort();
            byte[] byArray = new byte[Math.min(string.length() + 1, n - 2)];
            imageInputStream.readFully(byArray);
            boolean bl = string.equals(JPEGSegmentImageInputStream.asNullTerminatedAsciiString(byArray, 0));
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    static String asNullTerminatedAsciiString(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length - n; ++i) {
            if (byArray[n + i] != 0 && i <= 255) continue;
            return JPEGSegmentImageInputStream.asAsciiString(byArray, n, n + i);
        }
        return null;
    }

    static String asAsciiString(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, Charset.forName("ascii"));
    }

    private void streamInit() throws IOException {
        this.stream.seek(0L);
        try {
            int n = this.stream.readUnsignedShort();
            if (n != 65496) {
                throw new IIOException(String.format("Not a JPEG stream (starts with: 0x%04x, expected SOI: 0x%04x)", n, 65496));
            }
            this.segment = new Segment(n, 0L, 0L, 2L);
            this.segments.add(this.segment);
            this.currentSegment = this.segments.size() - 1;
        }
        catch (EOFException eOFException) {
            throw new IIOException(String.format("Not a JPEG stream (short stream. expected SOI: 0x%04x)", 65496), eOFException);
        }
    }

    static boolean isAppSegmentMarker(int n) {
        return n >= 65504 && n <= 65519;
    }

    private void repositionAsNecessary() throws IOException {
        if (this.segment == null || this.streamPos < this.segment.start || this.streamPos >= this.segment.end()) {
            try {
                this.fetchSegment();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        this.repositionAsNecessary();
        int n = this.segment.read(this.stream);
        if (n != -1) {
            ++this.streamPos;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        this.bitOffset = 0;
        for (n3 = 0; n3 < n2; n3 += n4) {
            this.repositionAsNecessary();
            long l = this.segment.end() - this.streamPos;
            int n5 = n4 = l == 0L ? -1 : this.segment.read(this.stream, byArray, n + n3, (int)Math.min((long)(n2 - n3), l));
            if (n4 == -1) {
                if (n3 != 0) break;
                return -1;
            }
            this.streamPos += (long)n4;
        }
        return n3;
    }

    @Override
    protected void finalize() throws Throwable {
    }

    static class ReplacementSegment
    extends Segment {
        final long realLength;
        final byte[] data;
        int pos;

        ReplacementSegment(int n, long l, long l2, long l3, byte[] byArray) {
            super(n, l, l2, byArray.length);
            this.realLength = l3;
            this.data = byArray;
        }

        @Override
        long realEnd() {
            return this.realStart + this.realLength;
        }

        @Override
        public void seek(ImageInputStream imageInputStream, long l) throws IOException {
            this.pos = (int)(l - this.start);
            super.seek(imageInputStream, l);
        }

        @Override
        public int read(ImageInputStream imageInputStream) {
            return this.data[this.pos++] & 0xFF;
        }

        @Override
        public int read(ImageInputStream imageInputStream, byte[] byArray, int n, int n2) {
            int n3 = Math.min(this.data.length - this.pos, n2);
            System.arraycopy(this.data, this.pos, byArray, n, n3);
            this.pos += n3;
            return n3;
        }
    }

    static final class DownsampledDQTReplacement
    extends ReplacementSegment {
        DownsampledDQTReplacement(long l, long l2, long l3, int n, ImageInputStream imageInputStream) throws IOException {
            super(65499, l, l2, l3, DownsampledDQTReplacement.createMarkerFixedLength((int)l3, n, imageInputStream));
        }

        private static byte[] createMarkerFixedLength(int n, int n2, ImageInputStream imageInputStream) throws IOException {
            byte[] byArray = new byte[n];
            int n3 = n / 128;
            int n4 = 2 + 65 * n3;
            byArray[0] = -1;
            byArray[1] = -37;
            byArray[2] = (byte)(n4 >> 8 & 0xFF);
            byArray[3] = (byte)(n4 & 0xFF);
            byArray[4] = (byte)(n2 & 0xF);
            imageInputStream.readFully(byArray, 5, byArray.length - 5);
            int n5 = 4;
            int n6 = 4;
            for (int i = 0; i < n3; ++i) {
                byArray[n5++] = (byte)(byArray[n6++] & 0xF);
                for (int j = 0; j < 64; ++j) {
                    byArray[n5 + j] = byArray[n6 + 1 + j * 2];
                }
                n5 += 64;
                n6 += 128;
            }
            return Arrays.copyOfRange(byArray, 0, n4 + 2);
        }
    }

    static final class AdobeAPP14Replacement
    extends ReplacementSegment {
        AdobeAPP14Replacement(long l, long l2, long l3, ImageInputStream imageInputStream) throws IOException {
            super(65518, l, l2, l3, AdobeAPP14Replacement.createMarkerFixedLength(imageInputStream));
        }

        private static byte[] createMarkerFixedLength(ImageInputStream imageInputStream) throws IOException {
            byte[] byArray = new byte[16];
            byArray[0] = -1;
            byArray[1] = -18;
            byArray[2] = 0;
            byArray[3] = 14;
            imageInputStream.readFully(byArray, 4, byArray.length - 4);
            return byArray;
        }
    }

    static class Segment {
        final int marker;
        final long realStart;
        final long start;
        final long length;

        Segment(int n, long l, long l2, long l3) {
            this.marker = n;
            this.realStart = l;
            this.start = l2;
            this.length = l3;
        }

        long realEnd() {
            return this.realStart + this.length;
        }

        long end() {
            return this.start + this.length;
        }

        public void seek(ImageInputStream imageInputStream, long l) throws IOException {
            imageInputStream.seek(this.realStart + l - this.start);
        }

        public int read(ImageInputStream imageInputStream) throws IOException {
            return imageInputStream.read();
        }

        public int read(ImageInputStream imageInputStream, byte[] byArray, int n, int n2) throws IOException {
            return imageInputStream.read(byArray, n, n2);
        }

        public String toString() {
            return String.format("0x%04x[%d-%d]", this.marker, this.realStart, this.realEnd());
        }
    }
}

