/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.algorithm;

import gov.sandia.cognition.algorithm.ParallelAlgorithm;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.NamedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParallelUtil {
    public static final int OPTIMAL_THREADS = -1;
    private static int DEFAULT_NUM_THREADS = -1;

    protected ParallelUtil() {
    }

    public static int getDefaultNumThreads() {
        return DEFAULT_NUM_THREADS;
    }

    public static void setDefaultNumThreads(int defaultNumThreads) {
        DEFAULT_NUM_THREADS = defaultNumThreads;
    }

    public static ThreadPoolExecutor createThreadPool() {
        return ParallelUtil.createThreadPool(ParallelUtil.getDefaultNumThreads());
    }

    public static ThreadPoolExecutor createThreadPool(int numRequestedThreads) {
        int numProcessors = Runtime.getRuntime().availableProcessors();
        int numThreads = numRequestedThreads == -1 ? (numProcessors <= 2 ? numProcessors : numProcessors - 1) : numRequestedThreads;
        if (numThreads < 1) {
            numThreads = 1;
        }
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(numThreads, ParallelUtil.defaultDaemonThreadFactory());
    }

    public static int getNumThreads(ParallelAlgorithm algorithm) {
        return algorithm == null ? 0 : ParallelUtil.getNumThreads(algorithm.getThreadPool());
    }

    public static int getNumThreads(ThreadPoolExecutor threadPool) {
        return threadPool == null ? 0 : threadPool.getMaximumPoolSize();
    }

    public static <ResultType> ArrayList<ResultType> executeInParallel(Collection<? extends Callable<ResultType>> tasks) throws InterruptedException, ExecutionException {
        return ParallelUtil.executeInParallel(tasks, ParallelUtil.createThreadPool());
    }

    public static <ResultType> ArrayList<ResultType> executeInParallel(Collection<? extends Callable<ResultType>> tasks, ThreadPoolExecutor threadPool) throws InterruptedException, ExecutionException {
        List futures = threadPool.invokeAll(tasks);
        ArrayList results = new ArrayList(futures.size());
        for (Future future : futures) {
            results.add(future.get());
        }
        return results;
    }

    public static <ResultType> ArrayList<ResultType> executeInParallel(Collection<? extends Callable<ResultType>> tasks, ParallelAlgorithm algorithm) throws InterruptedException, ExecutionException {
        return ParallelUtil.executeInParallel(tasks, algorithm.getThreadPool());
    }

    public static <ResultType> ArrayList<ResultType> executeInSequence(Collection<? extends Callable<ResultType>> tasks) throws Exception {
        ArrayList<ResultType> results = new ArrayList<ResultType>(tasks.size());
        for (Callable<ResultType> task : tasks) {
            results.add(task.call());
        }
        return results;
    }

    public static <ResultType> NamedValue<Double> compareTimes(Collection<? extends Callable<ResultType>> tasks) {
        return ParallelUtil.compareTimes(tasks, ParallelUtil.createThreadPool());
    }

    public static <ResultType> NamedValue<Double> compareTimes(Collection<? extends Callable<ResultType>> tasks, ThreadPoolExecutor threadPool) {
        try {
            long seriesStart = System.currentTimeMillis();
            ParallelUtil.executeInSequence(tasks);
            long seriesStop = System.currentTimeMillis();
            long parallelStart = System.currentTimeMillis();
            ParallelUtil.executeInParallel(tasks, threadPool);
            long parallelStop = System.currentTimeMillis();
            double seriesTime = (double)(seriesStop - seriesStart) / 1000.0;
            double parallelTime = (double)(parallelStop - parallelStart) / 1000.0;
            double parallelToSeriesRatio = parallelTime / seriesTime;
            String name = "Series time = " + seriesTime + ", Parallel time = " + parallelTime + ", Parallel/Series ratio = " + parallelToSeriesRatio + " using " + ParallelUtil.getNumThreads(threadPool) + " threads.";
            return new DefaultNamedValue<Double>(name, parallelToSeriesRatio);
        }
        catch (Exception ex) {
            Logger.getLogger(ParallelUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static ThreadFactory defaultDaemonThreadFactory() {
        return new DaemonThreadFactory(Executors.defaultThreadFactory());
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        protected ThreadFactory baseFactory;

        public DaemonThreadFactory(ThreadFactory baseFactory) {
            this.baseFactory = baseFactory;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.baseFactory.newThread(r);
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            return thread;
        }
    }
}

