/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.collection;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.util.CloneableSerializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=false, comments={"Cleaned up minor formatting issues.", "Added class documentation about running times and usage of LinkedList."})
public class FiniteCapacityBuffer<DataType>
extends AbstractList<DataType>
implements CloneableSerializable {
    private int capacity;
    private LinkedList<DataType> data = new LinkedList();

    public FiniteCapacityBuffer() {
        this(1);
    }

    public FiniteCapacityBuffer(int capacity) {
        this.setCapacity(capacity);
    }

    public FiniteCapacityBuffer(FiniteCapacityBuffer<DataType> other) {
        this(other.getCapacity());
        this.addAll(other.data);
    }

    @Override
    public FiniteCapacityBuffer<DataType> clone() {
        try {
            FiniteCapacityBuffer clone = (FiniteCapacityBuffer)super.clone();
            clone.setCapacity(this.capacity);
            clone.addAll(this.data);
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Iterator<DataType> iterator() {
        return this.data.iterator();
    }

    @Override
    public boolean add(DataType e) {
        return this.addLast(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.data.remove(o);
    }

    @Override
    public DataType remove(int index) {
        return this.data.remove(index);
    }

    public boolean addFirst(DataType e) {
        while (this.size() >= this.getCapacity()) {
            this.data.removeLast();
        }
        this.data.addFirst(e);
        return true;
    }

    public boolean addLast(DataType e) {
        while (this.size() >= this.getCapacity()) {
            this.data.removeFirst();
        }
        this.data.addLast(e);
        return true;
    }

    @Override
    public DataType getFirst() {
        return this.data.getFirst();
    }

    @Override
    public DataType getLast() {
        return this.data.getLast();
    }

    public boolean isFull() {
        return this.size() >= this.getCapacity();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity (" + capacity + ") must be > 0");
        }
        this.capacity = capacity;
        this.data = new LinkedList();
    }

    @Override
    public DataType get(int index) {
        return this.data.get(index);
    }
}

