/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.collection;

import gov.sandia.cognition.util.CloneableSerializable;
import java.util.AbstractCollection;
import java.util.Iterator;

public class IntegerCollection
extends AbstractCollection<Integer>
implements CloneableSerializable {
    private int minValue;
    private int maxValue;

    public IntegerCollection(int minValue, int maxValue) {
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue must be < maxValue");
        }
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
    }

    @Override
    public IntegerCollection clone() {
        try {
            return (IntegerCollection)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getMinValue() {
        return this.minValue;
    }

    protected void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    protected void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntegerIterator();
    }

    @Override
    public int size() {
        return this.maxValue - this.minValue + 1;
    }

    public boolean contains(int value) {
        return this.minValue <= value && value <= this.maxValue;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            return this.contains((Integer)o);
        }
        return false;
    }

    private class IntegerIterator
    implements Iterator<Integer> {
        private int currentIndex;

        public IntegerIterator() {
            this.currentIndex = IntegerCollection.this.getMinValue();
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex <= IntegerCollection.this.getMaxValue();
        }

        @Override
        public Integer next() {
            int previousIndex = this.currentIndex++;
            return previousIndex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove.");
        }
    }
}

