/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.collection;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.collection.MultiCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-02-08", changesNeeded=false, comments={"I'm impressed: iteration (foreach) works on this class.  I was ready to flunk this code review, but my unit test passes.", "Looks fine."})
public class RangeExcludedArrayList<E>
extends AbstractList<E>
implements RandomAccess,
MultiCollection<E> {
    private ArrayList<E> list;
    private int fromIndex;
    private int sizeExcluded;

    public RangeExcludedArrayList(ArrayList<E> list, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex >= list.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.list = list;
        this.fromIndex = fromIndex;
        this.sizeExcluded = toIndex + 1 - fromIndex;
    }

    @Override
    public E get(int index) {
        if (index < this.fromIndex) {
            return this.list.get(index);
        }
        return this.list.get(this.sizeExcluded + index);
    }

    @Override
    public int size() {
        return this.list.size() - this.sizeExcluded;
    }

    public List<? extends Collection<E>> subCollections() {
        int listSize;
        int toIndex;
        if (this.sizeExcluded <= 0) {
            return Collections.singletonList(this.list);
        }
        ArrayList<List<E>> result = new ArrayList<List<E>>(2);
        if (this.fromIndex > 0) {
            result.add(this.list.subList(0, this.fromIndex));
        }
        if ((toIndex = this.fromIndex + this.sizeExcluded) < (listSize = this.list.size())) {
            result.add(this.list.subList(toIndex, listSize));
        }
        return result;
    }

    @Override
    public int getSubCollectionsCount() {
        return this.subCollections().size();
    }
}

