/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.io;

import gov.sandia.cognition.annotation.CodeReview;
import java.io.File;

@CodeReview(reviewer={"Jonathan McClain"}, date="2006-05-11", changesNeeded=false, comments={"No changes necessary."})
public final class FileUtil {
    public static String getExtension(File file) {
        return FileUtil.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        String extension = null;
        int index = fileName.lastIndexOf(46);
        if (index > 0 && index < fileName.length() - 1) {
            extension = fileName.substring(index + 1);
        }
        return extension;
    }

    public static String removeExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index <= 0) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static boolean couldWrite(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.canWrite();
        }
        File parent = file.getParentFile();
        if (parent != null) {
            return parent.canWrite();
        }
        return false;
    }
}

