/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.io.serialization;

import com.thoughtworks.xstream.XStream;
import gov.sandia.cognition.io.serialization.AbstractTextSerializationHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;

public class XStreamSerializationHandler
extends AbstractTextSerializationHandler<Serializable> {
    private static XStreamSerializationHandler DEFAULT;
    protected transient XStream xstream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XStreamSerializationHandler getDefault() {
        Class<XStreamSerializationHandler> clazz = XStreamSerializationHandler.class;
        synchronized (XStreamSerializationHandler.class) {
            if (DEFAULT == null) {
                DEFAULT = new XStreamSerializationHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return DEFAULT;
        }
    }

    public XStreamSerializationHandler() {
        this(new XStream());
    }

    public XStreamSerializationHandler(XStream xstream) {
        if (xstream == null) {
            throw new NullPointerException("xstream cannot be null.");
        }
        this.xstream = xstream;
    }

    @Override
    public void writeObject(Writer writer, Serializable object) throws IOException {
        this.xstream.toXML((Object)object, writer);
    }

    @Override
    public Object readObject(Reader reader) throws IOException {
        Object object = this.xstream.fromXML(reader);
        reader.close();
        return object;
    }
}

