/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm;

import gov.sandia.cognition.algorithm.AbstractAnytimeAlgorithm;
import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.AnytimeBatchLearner;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Added some HTML formatting to the javadoc, removed useless javadoc.", "Code looks fine."})
public abstract class AbstractAnytimeBatchLearner<DataType, ResultType>
extends AbstractAnytimeAlgorithm<ResultType>
implements AnytimeBatchLearner<DataType, ResultType> {
    protected boolean keepGoing;
    protected DataType data;

    protected AbstractAnytimeBatchLearner(int maxIterations) {
        super(maxIterations);
        this.setKeepGoing(false);
    }

    @Override
    public AbstractAnytimeBatchLearner<DataType, ResultType> clone() {
        AbstractAnytimeBatchLearner result = (AbstractAnytimeBatchLearner)super.clone();
        result.keepGoing = false;
        result.data = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultType learn(DataType data) {
        this.setData(data);
        this.setIteration(0);
        this.setKeepGoing(true);
        boolean initialized = this.initializeAlgorithm();
        if (!initialized) {
            return null;
        }
        this.fireAlgorithmStarted();
        try {
            while (this.getKeepGoing()) {
                this.setIteration(this.getIteration() + 1);
                this.fireStepStarted();
                boolean stepReturn = false;
                try {
                    stepReturn = this.step();
                }
                finally {
                    this.fireStepEnded();
                }
                this.setKeepGoing(this.getKeepGoing() && stepReturn && this.getIteration() < this.getMaxIterations());
            }
        }
        finally {
            this.fireAlgorithmEnded();
        }
        this.cleanupAlgorithm();
        this.setData(null);
        return this.getResult();
    }

    protected abstract boolean initializeAlgorithm();

    protected abstract boolean step();

    protected abstract void cleanupAlgorithm();

    @Override
    public void stop() {
        this.setKeepGoing(false);
    }

    @Override
    public boolean getKeepGoing() {
        return this.keepGoing;
    }

    public void setKeepGoing(boolean keepGoing) {
        this.keepGoing = keepGoing;
    }

    @Override
    public DataType getData() {
        return this.data;
    }

    protected void setData(DataType data) {
        this.data = data;
    }
}

