/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.annealing;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.learning.algorithm.annealing.Perturber;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.decomposition.CholeskyDecompositionMTJ;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.AbstractRandomized;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Random;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Moved previous code review to annotation.", "Fixed a few typos in javadoc.", "Code looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-02", changesNeeded=false, comments={"Minor documentation updates."})})
public class VectorizablePerturber
extends AbstractRandomized
implements Perturber<Vectorizable> {
    private Matrix covarianceSqrt = null;

    public VectorizablePerturber(Random random, Matrix covariance) {
        super(random);
        this.setCovariance(covariance);
    }

    @Override
    public VectorizablePerturber clone() {
        VectorizablePerturber result = (VectorizablePerturber)super.clone();
        result.covarianceSqrt = ObjectUtil.cloneSafe(this.covarianceSqrt);
        return result;
    }

    @Override
    public Vectorizable perturb(Vectorizable input) {
        Vectorizable clone = input.clone();
        Vector parameters = clone.convertToVector();
        parameters = this.perturbVector(parameters);
        clone.convertFromVector(parameters);
        return clone;
    }

    public Vector perturbVector(Vector input) {
        Vector perturbed = MultivariateGaussian.sample(input, this.getCovarianceSqrt(), this.getRandom());
        return perturbed;
    }

    public void setCovariance(Matrix covariance) {
        DenseMatrix denseCovariance = DenseMatrixFactoryMTJ.INSTANCE.copyMatrix(covariance);
        this.setCovarianceSqrt(CholeskyDecompositionMTJ.create(denseCovariance).getR());
    }

    public Matrix getCovarianceSqrt() {
        return this.covarianceSqrt;
    }

    protected void setCovarianceSqrt(Matrix covarianceSqrt) {
        this.covarianceSqrt = covarianceSqrt;
    }
}

