/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering;

import gov.sandia.cognition.algorithm.AnytimeAlgorithmWrapper;
import gov.sandia.cognition.algorithm.MeasurablePerformanceAlgorithm;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.learning.algorithm.AnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.clustering.BatchClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.GaussianCluster;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.statistics.DataHistogram;
import gov.sandia.cognition.statistics.bayesian.DirichletProcessMixtureModel;
import gov.sandia.cognition.statistics.bayesian.ParallelDirichletProcessMixtureModel;
import gov.sandia.cognition.statistics.distribution.MultivariateGaussian;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.NamedValue;
import gov.sandia.cognition.util.Randomized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReferences(references={@PublicationReference(author={"Michael I. Jordan"}, title="Dirichlet Processes, Chinese Restaurant Processes and All That", type=PublicationType.Conference, publication="NIPS", year=2005, url="http://www.cs.berkeley.edu/~jordan/nips-tutorial05.ps"), @PublicationReference(author={"Radform M. Neal"}, title="Markov Chain Sampling Methods for Dirichlet Process Mixture Models", type=PublicationType.Journal, year=2000, publication="Journal of Computational and Graphical Statistics, Vol. 9, No. 2", pages={249, 265}, notes={"Based in part on Algorithm 2 from Neal"}), @PublicationReference(author={"Michael D. Escobar", "Mike West"}, title="Bayesian Density Estimation and Inference Using Mixtures", type=PublicationType.Journal, publication="Journal of the American Statistical Association", year=1995)})
public class DirichletProcessClustering
extends AnytimeAlgorithmWrapper<Collection<GaussianCluster>, DirichletProcessMixtureModel<Vector>>
implements BatchClusterer<Vector, GaussianCluster>,
AnytimeBatchLearner<Collection<? extends Vector>, Collection<GaussianCluster>>,
Randomized,
MeasurablePerformanceAlgorithm {
    public static final String PERFORMANCE_DESCRIPTION = "Number of Clusters";
    public static final int DEFAULT_DIMENSIONALITY = 2;
    public static final int DEFAULT_SAMPLES = 1000;
    private transient ArrayList<GaussianCluster> result = null;

    public DirichletProcessClustering() {
        this(2);
    }

    public DirichletProcessClustering(int dimensionality) {
        this((DirichletProcessMixtureModel<Vector>)new ParallelDirichletProcessMixtureModel<Vector>());
        this.setMaxIterations(1000);
        ((DirichletProcessMixtureModel)this.getAlgorithm()).setBurnInIterations(1);
        ((DirichletProcessMixtureModel)this.getAlgorithm()).setIterationsPerSample(1);
        ((DirichletProcessMixtureModel)this.getAlgorithm()).setNumInitialClusters(2);
        this.setRandom(new Random());
    }

    public DirichletProcessClustering(DirichletProcessMixtureModel<Vector> algorithm) {
        super(algorithm);
    }

    @Override
    public DirichletProcessClustering clone() {
        return (DirichletProcessClustering)super.clone();
    }

    @Override
    public ArrayList<GaussianCluster> getResult() {
        return this.result;
    }

    @Override
    public ArrayList<GaussianCluster> learn(Collection<? extends Vector> data) {
        this.result = null;
        if (((DirichletProcessMixtureModel)this.getAlgorithm()).getUpdater() == null) {
            int dim = CollectionUtil.getFirst(data).getDimensionality();
            ((DirichletProcessMixtureModel)this.getAlgorithm()).setUpdater(new DirichletProcessMixtureModel.MultivariateMeanCovarianceUpdater(dim));
        }
        DataHistogram dpmm = (DataHistogram)((DirichletProcessMixtureModel)this.getAlgorithm()).learn(data);
        int maxIndex = -1;
        double maxPosterior = Double.NEGATIVE_INFINITY;
        DirichletProcessMixtureModel.Sample maxSample = null;
        int i = 0;
        for (DirichletProcessMixtureModel.Sample sample : dpmm.getDomain()) {
            double posterior;
            if (sample.getPosteriorLogLikelihood() != null && maxPosterior < (posterior = sample.getPosteriorLogLikelihood().doubleValue())) {
                maxPosterior = posterior;
                maxIndex = i;
                maxSample = sample;
            }
            ++i;
        }
        int K = maxSample.getNumClusters();
        System.out.println("Max Index = " + maxIndex + ", K = " + K + ", Log-Posterior = " + maxPosterior);
        this.result = new ArrayList(K);
        for (int k = 0; k < K; ++k) {
            this.result.add(new GaussianCluster(maxSample.getClusters().get(k).getMembers(), (MultivariateGaussian.PDF)maxSample.getClusters().get(k).getProbabilityFunction()));
        }
        return this.getResult();
    }

    @Override
    public Random getRandom() {
        return ((DirichletProcessMixtureModel)this.getAlgorithm()).getRandom();
    }

    @Override
    public void setRandom(Random random) {
        ((DirichletProcessMixtureModel)this.getAlgorithm()).setRandom(random);
    }

    public NamedValue<Integer> getPerformance() {
        int numClusters = this.getAlgorithm() != null && ((DirichletProcessMixtureModel)this.getAlgorithm()).getCurrentParameter() != null ? ((DirichletProcessMixtureModel.Sample)((DirichletProcessMixtureModel)this.getAlgorithm()).getCurrentParameter()).getNumClusters() : 0;
        return new DefaultNamedValue<Integer>(PERFORMANCE_DESCRIPTION, numClusters);
    }

    @Override
    public boolean getKeepGoing() {
        return this.getAlgorithm() != null ? ((DirichletProcessMixtureModel)this.getAlgorithm()).getKeepGoing() : false;
    }

    @Override
    public Collection<? extends Vector> getData() {
        return this.getAlgorithm() != null ? (Collection)((DirichletProcessMixtureModel)this.getAlgorithm()).getData() : null;
    }
}

