/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering;

import gov.sandia.cognition.algorithm.ParallelUtil;
import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.factory.Factory;
import gov.sandia.cognition.learning.algorithm.clustering.ParallelizedKMeansClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.CentroidCluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.VectorMeanCentroidClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.CentroidClusterDivergenceFunction;
import gov.sandia.cognition.learning.algorithm.clustering.initializer.GreedyClusterInitializer;
import gov.sandia.cognition.learning.function.distance.EuclideanDistanceMetric;
import gov.sandia.cognition.math.Semimetric;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.AbstractRandomized;
import java.util.Random;

@CodeReview(reviewer={"Justin Basilico"}, date="2009-06-29", changesNeeded=false, comments={"Changed it to not have a default random, otherwise its good."})
public class KMeansFactory
extends AbstractRandomized
implements Factory<ParallelizedKMeansClusterer<Vector, CentroidCluster<Vector>>> {
    public static final int DEFAULT_NUM_CLUSTERS = 10;
    private int numClusters;

    public KMeansFactory() {
        this(10);
    }

    public KMeansFactory(int numClusters) {
        this(numClusters, new Random());
    }

    public KMeansFactory(int numClusters, Random random) {
        super(random);
        this.setNumClusters(numClusters);
    }

    public static ParallelizedKMeansClusterer<Vector, CentroidCluster<Vector>> create(int numClusters, Random random) {
        return KMeansFactory.create(numClusters, EuclideanDistanceMetric.INSTANCE, random);
    }

    public static ParallelizedKMeansClusterer<Vector, CentroidCluster<Vector>> create(int numClusters, Semimetric<? super Vector> distanceMetric, Random random) {
        VectorMeanCentroidClusterCreator clusterCreator = new VectorMeanCentroidClusterCreator();
        GreedyClusterInitializer<CentroidCluster<Vector>, Vector> initializer = new GreedyClusterInitializer<CentroidCluster<Vector>, Vector>(distanceMetric, clusterCreator, random);
        CentroidClusterDivergenceFunction clusterDivergence = new CentroidClusterDivergenceFunction(distanceMetric);
        return new ParallelizedKMeansClusterer<Vector, CentroidCluster<Vector>>(numClusters, 1000, ParallelUtil.createThreadPool(), initializer, clusterDivergence, clusterCreator);
    }

    @Override
    public ParallelizedKMeansClusterer<Vector, CentroidCluster<Vector>> create() {
        return KMeansFactory.create(this.getNumClusters(), this.getRandom());
    }

    public int getNumClusters() {
        return this.numClusters;
    }

    public void setNumClusters(int numClusters) {
        if (numClusters <= 0) {
            throw new IllegalArgumentException("numClusters must be positive.");
        }
        this.numClusters = numClusters;
    }
}

