/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering.cluster;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Interface looks fine."})
public class DefaultCluster<ClusterType>
extends AbstractCloneableSerializable
implements Cluster<ClusterType> {
    public static final int DEFAULT_INDEX = -1;
    private int index;
    private ArrayList<ClusterType> members;

    public DefaultCluster() {
        this(null);
    }

    public DefaultCluster(int index) {
        this(index, null);
    }

    public DefaultCluster(Collection<? extends ClusterType> members) {
        this(-1, members);
    }

    public DefaultCluster(int index, Collection<? extends ClusterType> members) {
        this.setIndex(index);
        if (members == null) {
            this.setMembers(new ArrayList());
        } else {
            this.setMembers(new ArrayList<ClusterType>(members));
        }
    }

    @Override
    public DefaultCluster<ClusterType> clone() {
        DefaultCluster clone = (DefaultCluster)super.clone();
        clone.setMembers((ArrayList)ObjectUtil.cloneSmart(this.getMembers()));
        return clone;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public ArrayList<ClusterType> getMembers() {
        return this.members;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private void setMembers(ArrayList<ClusterType> members) {
        this.members = members;
    }
}

