/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering.initializer;

import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.ClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.initializer.FixedClusterInitializer;
import gov.sandia.cognition.learning.function.distance.DefaultDivergenceFunctionContainer;
import gov.sandia.cognition.math.DivergenceFunction;
import gov.sandia.cognition.util.ArgumentChecker;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Randomized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public abstract class AbstractMinDistanceFixedClusterInitializer<ClusterType extends Cluster<DataType>, DataType>
extends DefaultDivergenceFunctionContainer<DataType, DataType>
implements FixedClusterInitializer<ClusterType, DataType>,
Randomized {
    protected ClusterCreator<ClusterType, DataType> creator;
    protected Random random;

    public AbstractMinDistanceFixedClusterInitializer() {
        this(null, null, new Random());
    }

    public AbstractMinDistanceFixedClusterInitializer(DivergenceFunction<? super DataType, ? super DataType> divergenceFunction, ClusterCreator<ClusterType, DataType> creator, Random random) {
        super(divergenceFunction);
        this.setCreator(creator);
        this.setRandom(random);
    }

    @Override
    public AbstractMinDistanceFixedClusterInitializer<ClusterType, DataType> clone() {
        AbstractMinDistanceFixedClusterInitializer clone = (AbstractMinDistanceFixedClusterInitializer)super.clone();
        clone.creator = ObjectUtil.cloneSafe(this.creator);
        return clone;
    }

    @Override
    public ArrayList<ClusterType> initializeClusters(int numClusters, Collection<? extends DataType> elements) {
        int selectedIndex;
        ArgumentChecker.assertIsNonNegative("numClusters", numClusters);
        if (numClusters == 0 || elements.size() == 0) {
            return new ArrayList();
        }
        int numElements = elements.size();
        ArrayList<DataType> elementsList = new ArrayList<DataType>(elements);
        if (numClusters > numElements) {
            numClusters = numElements;
        }
        ArrayList<DataType> clusterList = new ArrayList<DataType>(numClusters);
        int firstIndex = this.random.nextInt(numElements);
        DataType firstCluster = elementsList.get(firstIndex);
        clusterList.add(firstCluster);
        boolean[] selected = new boolean[numElements];
        double[] minDistances = new double[numElements];
        for (int i = 0; i < numElements; ++i) {
            if (i == firstIndex) {
                selected[i] = true;
                minDistances[i] = 0.0;
                continue;
            }
            selected[i] = false;
            minDistances[i] = this.divergenceFunction.evaluate(elementsList.get(i), firstCluster);
        }
        for (int clusterNum = 1; clusterNum < numClusters && (selectedIndex = this.selectNextClusterIndex(minDistances, selected)) >= 0; ++clusterNum) {
            selected[selectedIndex] = true;
            minDistances[selectedIndex] = 0.0;
            DataType cluster = elementsList.get(selectedIndex);
            clusterList.add(cluster);
            for (int i = 0; i < numElements; ++i) {
                if (selected[i]) continue;
                minDistances[i] = Math.min(minDistances[i], this.divergenceFunction.evaluate(cluster, elementsList.get(i)));
            }
        }
        numClusters = clusterList.size();
        ArrayList<ClusterType> clusters = new ArrayList<ClusterType>(numClusters);
        for (int i = 0; i < numClusters; ++i) {
            ArrayList singletonCluster = new ArrayList(1);
            singletonCluster.add(clusterList.get(i));
            ClusterType cluster = this.creator.createCluster(singletonCluster);
            clusters.add(cluster);
        }
        return clusters;
    }

    protected abstract int selectNextClusterIndex(double[] var1, boolean[] var2);

    public ClusterCreator<ClusterType, DataType> getCreator() {
        return this.creator;
    }

    public void setCreator(ClusterCreator<ClusterType, DataType> creator) {
        ArgumentChecker.assertIsNotNull("creator", creator);
        this.creator = creator;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public void setRandom(Random random) {
        this.random = random;
    }
}

