/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.confidence;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.AbstractSupervisedBatchAndIncrementalLearner;
import gov.sandia.cognition.learning.function.categorization.DiagonalConfidenceWeightedBinaryCategorizer;
import gov.sandia.cognition.math.matrix.DiagonalMatrix;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.statistics.distribution.UnivariateGaussian;
import gov.sandia.cognition.util.ArgumentChecker;

@PublicationReference(author={"Koby Crammer", "Mark Dredze", "Fernando Pereira"}, title="Exact Convex Confidence-Weighted Learning", year=2008, type=PublicationType.Conference, publication="Advances in Neural Information Processing Systems", url="http://citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.169.3364")
public class ConfidenceWeightedDiagonalDeviation
extends AbstractSupervisedBatchAndIncrementalLearner<Vectorizable, Boolean, DiagonalConfidenceWeightedBinaryCategorizer> {
    public static final double DEFAULT_CONFIDENCE = 0.85;
    public static final double DEFAULT_DEFAULT_VARIANCE = 1.0;
    protected double confidence;
    protected double defaultVariance;
    protected double phi;
    protected double psi;
    protected double epsilon;

    public ConfidenceWeightedDiagonalDeviation() {
        this(0.85, 1.0);
    }

    public ConfidenceWeightedDiagonalDeviation(double confidence, double defaultVariance) {
        this.setConfidence(confidence);
        this.setDefaultVariance(defaultVariance);
    }

    @Override
    public DiagonalConfidenceWeightedBinaryCategorizer createInitialLearnedObject() {
        return new DiagonalConfidenceWeightedBinaryCategorizer();
    }

    @Override
    public void update(DiagonalConfidenceWeightedBinaryCategorizer target, Vectorizable input, Boolean output) {
        if (input != null && output != null) {
            this.update(target, input.convertToVector(), (boolean)output);
        }
    }

    @Override
    public void update(DiagonalConfidenceWeightedBinaryCategorizer target, Vector input, boolean label) {
        Vector variance;
        Vector mean;
        if (!target.isInitialized()) {
            int dimensionality = input.getDimensionality();
            mean = VectorFactory.getDenseDefault().createVector(dimensionality);
            variance = VectorFactory.getDenseDefault().createVector(dimensionality, this.getDefaultVariance());
            target.setMean(mean);
            target.setVariance(variance);
        } else {
            mean = target.getMean();
            variance = target.getVariance();
        }
        double predicted = input.dotProduct(mean);
        double actual = label ? 1.0 : -1.0;
        double margin = actual * predicted;
        Vector varianceTimesInput = input.dotTimes(variance);
        double marginVariance = input.dotProduct(varianceTimesInput);
        double m = margin;
        double v = marginVariance;
        if (v == 0.0 || m > this.phi * Math.sqrt(v)) {
            return;
        }
        double alpha = (-m * this.psi + Math.sqrt(m * m * Math.pow(this.phi, 4.0) / 4.0 + v * this.phi * this.phi * this.epsilon)) / (v * this.epsilon);
        if ((alpha = Math.max(alpha, 0.0)) <= 0.0) {
            return;
        }
        double u = 0.25 * Math.pow(-alpha * v * this.phi + Math.sqrt(alpha * alpha * v * v * this.phi * this.phi + 4.0 * v), 2.0);
        double beta = alpha * this.phi / (Math.sqrt(u) + v * alpha * this.phi);
        Vector meanUpdate = (Vector)varianceTimesInput.scale(actual * alpha);
        mean.plusEquals(meanUpdate);
        DiagonalMatrix varianceInverseUpdate = MatrixFactory.getDiagonalDefault().createDiagonal(input.dotTimes(input));
        varianceInverseUpdate.scaleEquals(beta);
        Matrix varianceInverse = target.getCovariance().inverse();
        varianceInverse.plusEquals(varianceInverseUpdate);
        Matrix covariance = varianceInverse.inverse();
        for (int i = 0; i < variance.getDimensionality(); ++i) {
            variance.setElement(i, covariance.getElement(i, i));
        }
        target.setMean(mean);
        target.setVariance(variance);
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double confidence) {
        ArgumentChecker.assertIsInRangeInclusive("confidence", confidence, 0.5, 1.0);
        this.confidence = confidence;
        this.phi = -UnivariateGaussian.CDF.Inverse.evaluate(1.0 - confidence, 0.0, 1.0);
        this.psi = 1.0 + this.phi * this.phi / 2.0;
        this.epsilon = 1.0 + this.phi * this.phi;
    }

    public double getDefaultVariance() {
        return this.defaultVariance;
    }

    public void setDefaultVariance(double defaultVariance) {
        ArgumentChecker.assertIsPositive("defaultVariance", defaultVariance);
        this.defaultVariance = defaultVariance;
    }
}

