/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.ensemble;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeSupervisedBatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchLearnerContainer;
import gov.sandia.cognition.learning.algorithm.ensemble.WeightedBinaryEnsemble;
import gov.sandia.cognition.learning.data.DefaultWeightedInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.data.WeightedInputOutputPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Added PublicationReference", "Cleaned up javadoc a little bit with code annotations.", "Otherwise, looks fine."})
@PublicationReference(author={"Yoav Freund", "Robert E.Schapire"}, title="A decision-theoretic generalization of on-line learning and an application to boosting", publication="Journal of Computer and System Sciences", notes={"Volume 55, Number 1"}, year=1997, pages={119, 139}, type=PublicationType.Journal, url="http://www.cse.ucsd.edu/~yfreund/papers/adaboost.pdf")
public class AdaBoost<InputType>
extends AbstractAnytimeSupervisedBatchLearner<InputType, Boolean, WeightedBinaryEnsemble<InputType, Evaluator<? super InputType, ? extends Boolean>>>
implements BatchLearnerContainer<BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>>> {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    protected BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> weakLearner;
    protected transient WeightedBinaryEnsemble<InputType, Evaluator<? super InputType, ? extends Boolean>> ensemble;
    protected transient ArrayList<DefaultWeightedInputOutputPair<InputType, Boolean>> weightedData;

    public AdaBoost() {
        this(null);
    }

    public AdaBoost(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> weakLearner) {
        this(weakLearner, 100);
    }

    public AdaBoost(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> weakLearner, int maxIterations) {
        super(maxIterations);
        this.setWeakLearner(weakLearner);
        this.setEnsemble(null);
        this.setWeightedData(null);
    }

    @Override
    protected boolean initializeAlgorithm() {
        if (this.getData() == null || ((Collection)this.getData()).size() <= 0) {
            return false;
        }
        this.setEnsemble(new WeightedBinaryEnsemble(new LinkedList()));
        int numExamples = 0;
        this.setWeightedData(new ArrayList<DefaultWeightedInputOutputPair<InputType, Boolean>>(((Collection)this.getData()).size()));
        for (InputOutputPair example : (Collection)this.getData()) {
            if (example == null) continue;
            this.weightedData.add(new DefaultWeightedInputOutputPair(example, 1.0));
            ++numExamples;
        }
        double initialWeight = 1.0 / (double)numExamples;
        for (DefaultWeightedInputOutputPair<InputType, Boolean> example : this.weightedData) {
            example.setWeight(initialWeight);
        }
        return true;
    }

    @Override
    protected boolean step() {
        Evaluator learned = this.weakLearner.learn(this.weightedData);
        if (learned == null) {
            return false;
        }
        double error = 0.0;
        int numExamples = this.weightedData.size();
        double[] predictions = new double[numExamples];
        for (int i = 0; i < numExamples; ++i) {
            double actual;
            WeightedInputOutputPair example = this.weightedData.get(i);
            Boolean prediction = learned.evaluate(example.getInput());
            double predictionDouble = 0.0;
            predictionDouble = prediction == null ? 0.0 : (prediction != false ? 1.0 : -1.0);
            predictions[i] = predictionDouble;
            double d = actual = (Boolean)example.getOutput() != false ? 1.0 : -1.0;
            if (!(actual * predictionDouble < 0.0)) continue;
            error += example.getWeight();
        }
        if (error >= 0.5) {
            return false;
        }
        double alpha = 1.0;
        if (error > 0.0) {
            alpha = 0.5 * Math.log((1.0 - error) / error);
        }
        this.ensemble.add(learned, alpha);
        double sum = 0.0;
        for (int i = 0; i < numExamples; ++i) {
            DefaultWeightedInputOutputPair<InputType, Boolean> example = this.weightedData.get(i);
            double predicted = predictions[i];
            double actual = (Boolean)example.getOutput() != false ? 1.0 : -1.0;
            double oldWeight = example.getWeight();
            double newWeight = oldWeight * Math.exp(-alpha * actual * predicted);
            example.setWeight(newWeight);
            sum += newWeight;
        }
        for (DefaultWeightedInputOutputPair<InputType, Boolean> example : this.weightedData) {
            example.setWeight(example.getWeight() / sum);
        }
        return true;
    }

    @Override
    protected void cleanupAlgorithm() {
        this.setWeightedData(null);
    }

    @Override
    public WeightedBinaryEnsemble<InputType, Evaluator<? super InputType, ? extends Boolean>> getResult() {
        return this.getEnsemble();
    }

    @Override
    public BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> getLearner() {
        return this.getWeakLearner();
    }

    public BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> getWeakLearner() {
        return this.weakLearner;
    }

    public void setWeakLearner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, Boolean>>, ? extends Evaluator<? super InputType, ? extends Boolean>> weakLearner) {
        this.weakLearner = weakLearner;
    }

    public WeightedBinaryEnsemble<InputType, Evaluator<? super InputType, ? extends Boolean>> getEnsemble() {
        return this.ensemble;
    }

    protected void setEnsemble(WeightedBinaryEnsemble<InputType, Evaluator<? super InputType, ? extends Boolean>> ensemble) {
        this.ensemble = ensemble;
    }

    public ArrayList<DefaultWeightedInputOutputPair<InputType, Boolean>> getWeightedData() {
        return this.weightedData;
    }

    protected void setWeightedData(ArrayList<DefaultWeightedInputOutputPair<InputType, Boolean>> weightedData) {
        this.weightedData = weightedData;
    }
}

