/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.ensemble;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeSupervisedBatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchLearnerContainer;
import gov.sandia.cognition.learning.algorithm.ensemble.WeightedVotingCategorizerEnsemble;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.util.Randomized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@PublicationReference(title="Bagging Predictors", author={"Leo Breiman"}, year=1996, type=PublicationType.Journal, publication="Machine Learning", pages={123, 140}, url="http://www.springerlink.com/index/L4780124W2874025.pdf")
public class BaggingCategorizerLearner<InputType, CategoryType>
extends AbstractAnytimeSupervisedBatchLearner<InputType, CategoryType, WeightedVotingCategorizerEnsemble<InputType, CategoryType, Evaluator<? super InputType, ? extends CategoryType>>>
implements Randomized,
BatchLearnerContainer<BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>>> {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    public static final double DEFAULT_PERCENT_TO_SAMPLE = 1.0;
    protected BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> learner;
    protected double percentToSample;
    protected Random random;
    protected transient WeightedVotingCategorizerEnsemble<InputType, CategoryType, Evaluator<? super InputType, ? extends CategoryType>> ensemble;
    protected transient ArrayList<? extends InputOutputPair<? extends InputType, CategoryType>> dataList;
    protected transient int[] dataInBag;
    protected transient ArrayList<InputOutputPair<? extends InputType, CategoryType>> bag;

    public BaggingCategorizerLearner() {
        this(null);
    }

    public BaggingCategorizerLearner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> learner) {
        this(learner, 100, 1.0, new Random());
    }

    public BaggingCategorizerLearner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> learner, int maxIterations, double percentToSample, Random random) {
        super(maxIterations);
        this.setLearner(learner);
        this.setPercentToSample(percentToSample);
        this.setRandom(random);
        this.setEnsemble(null);
        this.dataList = null;
        this.dataInBag = null;
        this.bag = null;
    }

    @Override
    protected boolean initializeAlgorithm() {
        int dataSize = CollectionUtil.size((Collection)this.getData());
        if (dataSize <= 0) {
            return false;
        }
        if (this.random == null) {
            this.random = new Random();
        }
        WeightedVotingCategorizerEnsemble localEmsemble = new WeightedVotingCategorizerEnsemble(DatasetUtil.findUniqueOutputs((Iterable)this.getData()));
        this.setEnsemble(localEmsemble);
        this.dataList = CollectionUtil.asArrayList((Iterable)this.getData());
        this.dataInBag = new int[dataSize];
        this.bag = new ArrayList();
        return true;
    }

    @Override
    protected boolean step() {
        int dataSize = this.dataList.size();
        int sampleCount = Math.max(1, (int)(this.percentToSample * (double)dataSize));
        this.bag.clear();
        for (int i = 0; i < dataSize; ++i) {
            this.dataInBag[i] = 0;
        }
        this.fillBag(sampleCount);
        Evaluator<? super InputType, ? extends CategoryType> learned = this.learner.learn(this.bag);
        this.ensemble.add(learned, 1.0);
        return true;
    }

    protected void fillBag(int sampleCount) {
        int dataSize = this.dataList.size();
        for (int i = 0; i < sampleCount; ++i) {
            int index = this.getRandom().nextInt(dataSize);
            InputOutputPair<? extends InputType, CategoryType> example = this.dataList.get(index);
            this.bag.add(example);
            int n = index;
            this.dataInBag[n] = this.dataInBag[n] + 1;
        }
    }

    @Override
    protected void cleanupAlgorithm() {
        this.dataList = null;
        this.dataInBag = null;
        this.bag = null;
    }

    @Override
    public WeightedVotingCategorizerEnsemble<InputType, CategoryType, Evaluator<? super InputType, ? extends CategoryType>> getResult() {
        return this.ensemble;
    }

    @Override
    public BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> getLearner() {
        return this.learner;
    }

    public void setLearner(BatchLearner<? super Collection<? extends InputOutputPair<? extends InputType, CategoryType>>, ? extends Evaluator<? super InputType, ? extends CategoryType>> learner) {
        this.learner = learner;
    }

    public double getPercentToSample() {
        return this.percentToSample;
    }

    public void setPercentToSample(double percentToSample) {
        if (percentToSample <= 0.0) {
            throw new IllegalArgumentException("percentToSample must be greater than zero.");
        }
        this.percentToSample = percentToSample;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public void setRandom(Random random) {
        this.random = random;
    }

    protected void setEnsemble(WeightedVotingCategorizerEnsemble<InputType, CategoryType, Evaluator<? super InputType, ? extends CategoryType>> ensemble) {
        this.ensemble = ensemble;
    }

    public ArrayList<InputOutputPair<? extends InputType, CategoryType>> getBag() {
        return this.bag;
    }
}

