/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.ensemble;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.ensemble.Ensemble;
import gov.sandia.cognition.learning.data.DefaultWeightedValueDiscriminant;
import gov.sandia.cognition.learning.function.categorization.AbstractDiscriminantCategorizer;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;
import gov.sandia.cognition.util.ArgumentChecker;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class VotingCategorizerEnsemble<InputType, CategoryType, MemberType extends Evaluator<? super InputType, ? extends CategoryType>>
extends AbstractDiscriminantCategorizer<InputType, CategoryType, Double>
implements Ensemble<MemberType> {
    protected List<MemberType> members;

    public VotingCategorizerEnsemble() {
        this(new LinkedHashSet());
    }

    public VotingCategorizerEnsemble(Set<CategoryType> categories) {
        this(categories, new ArrayList());
    }

    public VotingCategorizerEnsemble(Set<CategoryType> categories, List<MemberType> members) {
        super(categories);
        this.setMembers(members);
    }

    public void add(MemberType member) {
        ArgumentChecker.assertIsNotNull("member", member);
        this.getMembers().add(member);
    }

    @Override
    public CategoryType evaluate(InputType input) {
        return this.evaluateAsVotes(input).getMaximumValue();
    }

    public DefaultWeightedValueDiscriminant<CategoryType> evaluateWithDiscriminant(InputType input) {
        MapBasedDataHistogram<CategoryType> votes = this.evaluateAsVotes(input);
        CategoryType bestCategory = votes.getMaximumValue();
        double bestFraction = votes.getFraction(bestCategory);
        return DefaultWeightedValueDiscriminant.create(bestCategory, bestFraction);
    }

    public MapBasedDataHistogram<CategoryType> evaluateAsVotes(InputType input) {
        MapBasedDataHistogram votes = new MapBasedDataHistogram(this.getCategories().size());
        for (Evaluator member : this.getMembers()) {
            Object category = member.evaluate(input);
            if (category == null) continue;
            votes.add(category);
        }
        return votes;
    }

    @Override
    public List<MemberType> getMembers() {
        return this.members;
    }

    public void setMembers(List<MemberType> members) {
        this.members = members;
    }
}

