/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.genetic;

import gov.sandia.cognition.algorithm.MeasurablePerformanceAlgorithm;
import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchCostMinimizationLearner;
import gov.sandia.cognition.learning.algorithm.genetic.EvaluatedGenome;
import gov.sandia.cognition.learning.algorithm.genetic.reproducer.Reproducer;
import gov.sandia.cognition.learning.function.cost.CostFunction;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.NamedValue;
import java.util.ArrayList;
import java.util.Collection;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"I don't much like the constructors for this class, but it's probably not worth changing at this point.", "Made some cosmetic changes to the code.", "Added previous code review as CodeReview annotation", "Otherwise, looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-05", changesNeeded=false, comments={"Cleaned up the code a little.", "Made the constructor initialize the variables."})})
public class GeneticAlgorithm<CostParametersType, GenomeType>
extends AbstractAnytimeBatchLearner<CostParametersType, GenomeType>
implements BatchCostMinimizationLearner<CostParametersType, GenomeType>,
MeasurablePerformanceAlgorithm {
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    private CostFunction<? super GenomeType, ? super CostParametersType> costFunction;
    private Reproducer<GenomeType> reproducer;
    private EvaluatedGenome<GenomeType> bestSoFar;
    private int maxIterationsWithoutImprovement;
    private int iterationsWithoutImprovement;
    private Collection<EvaluatedGenome<GenomeType>> population;
    private Collection<GenomeType> initialPopulation;

    public GeneticAlgorithm(Collection<GenomeType> initialPopulation, Reproducer<GenomeType> reproducer, CostFunction<? super GenomeType, ? super CostParametersType> cost) {
        this(initialPopulation, reproducer, cost, 1000);
    }

    public GeneticAlgorithm(Collection<GenomeType> initialPopulation, Reproducer<GenomeType> reproducer, CostFunction<? super GenomeType, ? super CostParametersType> cost, int maxIterations) {
        this(initialPopulation, reproducer, cost, maxIterations, 1 + maxIterations / 10);
    }

    public GeneticAlgorithm(Collection<GenomeType> initialPopulation, Reproducer<GenomeType> reproducer, CostFunction<? super GenomeType, ? super CostParametersType> cost, int maxIterations, int maxIterationsWithoutImprovement) {
        super(maxIterations);
        this.setCostFunction(cost);
        this.setReproducer(reproducer);
        this.setBestSoFar(null);
        this.setMaxIterationsWithoutImprovement(maxIterationsWithoutImprovement);
        this.setIterationsWithoutImprovement(0);
        this.setPopulation(null);
        this.setInitialPopulation(initialPopulation);
    }

    @Override
    protected boolean initializeAlgorithm() {
        if (this.getPopulation() == null) {
            this.setPopulation(this.evaluatePopulation(this.getInitialPopulation()));
        }
        this.setBestSoFar(this.searchForBetter(this.getBestSoFar(), this.getPopulation()));
        this.setIteration(0);
        this.setIterationsWithoutImprovement(0);
        return true;
    }

    @Override
    protected boolean step() {
        this.setPopulation(this.evaluatePopulation(this.getReproducer().reproduce(this.getPopulation())));
        EvaluatedGenome<GenomeType> best = this.searchForBetter(this.getBestSoFar(), this.getPopulation());
        if (best.getCost() < this.getBestSoFar().getCost()) {
            this.setBestSoFar(best);
            this.setIterationsWithoutImprovement(0);
        } else {
            this.setIterationsWithoutImprovement(this.getIterationsWithoutImprovement() + 1);
        }
        return this.getIterationsWithoutImprovement() <= this.getMaxIterationsWithoutImprovement();
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    @Override
    public GenomeType getResult() {
        return this.getBestSoFar() != null ? (GenomeType)this.getBestSoFar().getGenome() : null;
    }

    protected EvaluatedGenome<GenomeType> searchForBetter(EvaluatedGenome<GenomeType> bestSoFar, Collection<EvaluatedGenome<GenomeType>> population) {
        EvaluatedGenome<GenomeType> currentBest = bestSoFar;
        for (EvaluatedGenome<GenomeType> evaluatedGenome : population) {
            if (currentBest != null && !(evaluatedGenome.getCost() < currentBest.getCost())) continue;
            currentBest = evaluatedGenome;
        }
        return currentBest;
    }

    protected ArrayList<EvaluatedGenome<GenomeType>> evaluatePopulation(Collection<GenomeType> population) {
        ArrayList<EvaluatedGenome<GenomeType>> evaluatedPopulation = new ArrayList<EvaluatedGenome<GenomeType>>(population.size());
        for (GenomeType genome : population) {
            double cost = this.getCostFunction().evaluate(genome);
            evaluatedPopulation.add(new EvaluatedGenome<GenomeType>(cost, genome));
        }
        return evaluatedPopulation;
    }

    @Override
    public CostFunction<? super GenomeType, ? super CostParametersType> getCostFunction() {
        return this.costFunction;
    }

    public Reproducer<GenomeType> getReproducer() {
        return this.reproducer;
    }

    public EvaluatedGenome<GenomeType> getBestSoFar() {
        return this.bestSoFar;
    }

    public int getMaxIterationsWithoutImprovement() {
        return this.maxIterationsWithoutImprovement;
    }

    public int getIterationsWithoutImprovement() {
        return this.iterationsWithoutImprovement;
    }

    public Collection<EvaluatedGenome<GenomeType>> getPopulation() {
        return this.population;
    }

    public void setCostFunction(CostFunction<? super GenomeType, ? super CostParametersType> cost) {
        this.costFunction = cost;
    }

    public void setReproducer(Reproducer<GenomeType> reproducer) {
        this.reproducer = reproducer;
    }

    public void setBestSoFar(EvaluatedGenome<GenomeType> bestSoFar) {
        this.bestSoFar = bestSoFar;
    }

    public void setMaxIterationsWithoutImprovement(int maxIterationsWithoutImprovement) {
        this.maxIterationsWithoutImprovement = maxIterationsWithoutImprovement;
    }

    public void setIterationsWithoutImprovement(int iterationsWithoutImprovement) {
        this.iterationsWithoutImprovement = iterationsWithoutImprovement;
    }

    public void setPopulation(Collection<EvaluatedGenome<GenomeType>> population) {
        this.population = population;
    }

    public Collection<GenomeType> getInitialPopulation() {
        return this.initialPopulation;
    }

    public void setInitialPopulation(Collection<GenomeType> initialPopulation) {
        this.initialPopulation = initialPopulation;
    }

    public NamedValue<Double> getPerformance() {
        return new DefaultNamedValue<Double>("cost", this.getBestSoFar().getCost());
    }
}

