/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.genetic.selector;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.learning.algorithm.genetic.EvaluatedGenome;
import gov.sandia.cognition.learning.algorithm.genetic.selector.AbstractSelector;
import gov.sandia.cognition.util.Randomized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Now implements Randomized.", "Moved previous code review as CodeReview annotation", "Looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-04", changesNeeded=false, comments={"I optimized the code to make it faster and use less memory.", "I also made the Random object a parameter of the class, not generated each time select is called."})})
public class TournamentSelector<GenomeType>
extends AbstractSelector<GenomeType>
implements Randomized {
    private double percent = 0.0;
    private int tournamentSize = 0;
    private Random random = null;

    public TournamentSelector(double percent, int tournamentSize) {
        this(percent, tournamentSize, new Random());
    }

    public TournamentSelector(double percent, int tournamentSize, Random random) {
        this.setPercent(percent);
        this.setTournamentSize(tournamentSize);
        this.setRandom(random);
    }

    @Override
    public Collection<EvaluatedGenome<GenomeType>> select(Collection<EvaluatedGenome<GenomeType>> genomes) {
        ArrayList<EvaluatedGenome<GenomeType>> population = genomes instanceof ArrayList ? (ArrayList<EvaluatedGenome<GenomeType>>)genomes : new ArrayList<EvaluatedGenome<GenomeType>>(genomes);
        int numToCreate = (int)Math.round((double)population.size() * this.getPercent());
        ArrayList<EvaluatedGenome<GenomeType>> selectedPopulation = new ArrayList<EvaluatedGenome<GenomeType>>(numToCreate);
        int tournySize = this.getTournamentSize();
        int numGenomes = genomes.size();
        Random rng = this.getRandom();
        for (int i = 0; i < numToCreate; ++i) {
            EvaluatedGenome<GenomeType> winner = null;
            for (int j = 0; j < tournySize; ++j) {
                int randomIndex = rng.nextInt(numGenomes);
                EvaluatedGenome<GenomeType> genome = population.get(randomIndex);
                if (winner != null && !(genome.getCost() < winner.getCost())) continue;
                winner = genome;
            }
            selectedPopulation.add(winner);
        }
        return selectedPopulation;
    }

    public double getPercent() {
        return this.percent;
    }

    public int getTournamentSize() {
        return this.tournamentSize;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    public void setPercent(double percent) {
        if (percent <= 0.0) {
            throw new IllegalArgumentException("The percentage must be positive.");
        }
        this.percent = percent;
    }

    public void setTournamentSize(int tournamentSize) {
        if (tournamentSize <= 0) {
            throw new IllegalArgumentException("The tournament size must be positive.");
        }
        this.tournamentSize = tournamentSize;
    }

    @Override
    public void setRandom(Random random) {
        this.random = random;
    }
}

