/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.gradient;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.gradient.GradientDescendable;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorizableVectorFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Minor change to class javadoc.", "Looks fine."})
@PublicationReference(author={"Wikipedia"}, title="Numerical differentiation", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Numerical_differentiation")
public class GradientDescendableApproximator
extends AbstractCloneableSerializable
implements GradientDescendable {
    public static final double DEFAULT_DELTA_SIZE = 1.0E-5;
    private double deltaSize;
    private VectorizableVectorFunction function;

    public GradientDescendableApproximator() {
        this(null);
    }

    public GradientDescendableApproximator(VectorizableVectorFunction function) {
        this(function, 1.0E-5);
    }

    public GradientDescendableApproximator(VectorizableVectorFunction function, double deltaSize) {
        this.setFunction(function);
        this.setDeltaSize(deltaSize);
    }

    @Override
    public GradientDescendableApproximator clone() {
        GradientDescendableApproximator clone = (GradientDescendableApproximator)super.clone();
        clone.setFunction(ObjectUtil.cloneSafe(this.getFunction()));
        return clone;
    }

    public VectorizableVectorFunction getFunction() {
        return this.function;
    }

    public void setFunction(VectorizableVectorFunction function) {
        this.function = function;
    }

    @Override
    public Vector convertToVector() {
        return this.getFunction().convertToVector();
    }

    @Override
    public void convertFromVector(Vector parameters) {
        this.getFunction().convertFromVector(parameters);
    }

    @Override
    public Vector evaluate(Vector input) {
        return (Vector)this.getFunction().evaluate(input);
    }

    public static Matrix computeParameterGradient(VectorizableVectorFunction function, Vector input, double deltaSize) {
        Vector fx = (Vector)function.evaluate(input);
        int M = fx.getDimensionality();
        Vector p = function.convertToVector();
        int N = p.getDimensionality();
        Matrix J = MatrixFactory.getDefault().createMatrix(M, N);
        for (int j = 0; j < N; ++j) {
            double v = p.getElement(j);
            p.setElement(j, v + deltaSize);
            function.convertFromVector(p);
            Vector fjx = (Vector)function.evaluate(input);
            fjx.minusEquals(fx);
            fjx.scaleEquals(1.0 / deltaSize);
            J.setColumn(j, fjx);
            p.setElement(j, v);
        }
        return J;
    }

    @Override
    public Matrix computeParameterGradient(Vector input) {
        return GradientDescendableApproximator.computeParameterGradient(this.getFunction(), input, this.getDeltaSize());
    }

    public double getDeltaSize() {
        return this.deltaSize;
    }

    public void setDeltaSize(double deltaSize) {
        this.deltaSize = deltaSize;
    }
}

