/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizerQuasiNewton;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizer;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReferences(references={@PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={55}, notes={"Section 3.2, Equation 3.2.12"}), @PublicationReference(author={"Wikipedia"}, title="BFGS method", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/BFGS_method"), @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={428, 429}, notes={"Section 10.7"}, url="http://www.nrbook.com/a/bookcpdf.php")})
public class FunctionMinimizerBFGS
extends FunctionMinimizerQuasiNewton {
    public FunctionMinimizerBFGS() {
        this(ObjectUtil.cloneSafe(DEFAULT_LINE_MINIMIZER));
    }

    public FunctionMinimizerBFGS(LineMinimizer<?> lineMinimizer) {
        super(lineMinimizer, null, 1.0E-5, 1000);
    }

    public FunctionMinimizerBFGS(LineMinimizer<?> lineMinimizer, Vector initialGuess, double tolerance, int maxIterations) {
        super(lineMinimizer, initialGuess, tolerance, maxIterations);
    }

    @Override
    public boolean updateHessianInverse(Matrix hessianInverse, Vector delta, Vector gamma) {
        return FunctionMinimizerBFGS.BFGSupdateRule(hessianInverse, delta, gamma, this.getTolerance());
    }

    @PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={55}, notes={"Section 3.2, Equation 3.2.12"})
    public static boolean BFGSupdateRule(Matrix hessianInverse, Vector delta, Vector gamma, double tolerance) {
        int M = hessianInverse.getNumRows();
        Vector Higamma = hessianInverse.times(gamma);
        double deltaTgamma = delta.dotProduct(gamma);
        if (Math.sqrt(tolerance * delta.norm2Squared() * gamma.norm2Squared()) >= Math.abs(deltaTgamma)) {
            return false;
        }
        double term1 = 1.0 + gamma.dotProduct(Higamma) / deltaTgamma;
        for (int i = 0; i < M; ++i) {
            double deltai = delta.getElement(i);
            double Higammai = Higamma.getElement(i);
            for (int j = 0; j <= i; ++j) {
                double oldValue = hessianInverse.getElement(i, j);
                double change = term1 * deltai * delta.getElement(j);
                change -= deltai * Higamma.getElement(j) + Higammai * delta.getElement(j);
                double newValue = oldValue + (change /= deltaTgamma);
                hessianInverse.setElement(i, j, newValue);
                if (i == j) continue;
                hessianInverse.setElement(j, i, newValue);
            }
        }
        return true;
    }
}

