/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizerQuasiNewton;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizer;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReferences(references={@PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={54}, notes={"Section 3.2, Equation 3.2.11"}), @PublicationReference(author={"Wikipedia"}, title="Davidon-Fletcher-Powell formula", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/Davidon-Fletcher-Powell_formula")})
public class FunctionMinimizerDFP
extends FunctionMinimizerQuasiNewton {
    public FunctionMinimizerDFP() {
        this(ObjectUtil.cloneSafe(DEFAULT_LINE_MINIMIZER));
    }

    public FunctionMinimizerDFP(LineMinimizer<?> lineMinimizer) {
        this(lineMinimizer, null, 1.0E-5, 1000);
    }

    public FunctionMinimizerDFP(LineMinimizer<?> lineMinimizer, Vector initialGuess, double tolerance, int maxIterations) {
        super(lineMinimizer, initialGuess, tolerance, maxIterations);
    }

    @Override
    @PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={54}, notes={"Section 3.2, Equation 3.2.11"})
    protected boolean updateHessianInverse(Matrix hessianInverse, Vector delta, Vector gamma) {
        int M = hessianInverse.getNumRows();
        Vector Higamma = hessianInverse.times(gamma);
        double deltaTgamma = delta.dotProduct(gamma);
        double gammaTHigamma = gamma.dotProduct(Higamma);
        double singularThreshold = Math.sqrt(this.getTolerance() * delta.norm2Squared() * gamma.norm2Squared());
        if (singularThreshold >= Math.abs(deltaTgamma) || singularThreshold >= Math.abs(gammaTHigamma)) {
            return false;
        }
        for (int i = 0; i < M; ++i) {
            double deltai = delta.getElement(i);
            double Higammai = Higamma.getElement(i);
            for (int j = 0; j <= i; ++j) {
                double oldValue = hessianInverse.getElement(i, j);
                double change = deltai * delta.getElement(j) / deltaTgamma;
                double newValue = oldValue + (change -= Higammai * Higamma.getElement(j) / gammaTHigamma);
                hessianInverse.setElement(i, j, newValue);
                if (i == j) continue;
                hessianInverse.setElement(j, i, newValue);
            }
        }
        return true;
    }
}

