/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizerConjugateGradient;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReference(author={"Y. Liu", "C. Storey"}, title="Efficient generalized conjugate gradient algorithms, Part 1: theory", type=PublicationType.Journal, publication="Journal of Optimization Theory and Applications", pages={129, 137}, year=1991, notes={"I've seen independent analyses that indicate that this is the most efficient CG algorithm out there.", "For example, http://www.ici.ro/camo/neculai/cg.ppt"})
public class FunctionMinimizerLiuStorey
extends FunctionMinimizerConjugateGradient {
    public FunctionMinimizerLiuStorey() {
        this(ObjectUtil.cloneSafe(DEFAULT_LINE_MINIMIZER));
    }

    public FunctionMinimizerLiuStorey(LineMinimizer<?> lineMinimizer) {
        this(lineMinimizer, null, 1.0E-5, 1000);
    }

    public FunctionMinimizerLiuStorey(LineMinimizer<?> lineMinimizer, Vector initialGuess, double tolerance, int maxIterations) {
        super(lineMinimizer, initialGuess, tolerance, maxIterations);
    }

    @Override
    protected double computeScaleFactor(Vector gradientCurrent, Vector gradientPrevious) {
        Vector direction = this.lineFunction.getDirection();
        Vector deltaGradient = gradientCurrent.minus(gradientPrevious);
        double deltaTgradient = deltaGradient.dotProduct(gradientCurrent);
        double denom = gradientPrevious.dotProduct(direction);
        double beta = -deltaTgradient / denom;
        return beta;
    }
}

