/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.minimization.AbstractAnytimeFunctionMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.MinimizationStoppingCriterion;
import gov.sandia.cognition.learning.algorithm.minimization.line.DirectionalVectorToDifferentiableScalarFunction;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizerDerivativeBased;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.math.DifferentiableEvaluator;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;

@PublicationReferences(references={@PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={49, 57}, notes={"Section 3.2"}), @PublicationReference(author={"Wikipedia"}, title="Quasi-Newton method", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/Quasi-Newton_methods"), @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={425, 430}, notes={"Section 10.7"}, url="http://www.nrbook.com/a/bookcpdf.php")})
public abstract class FunctionMinimizerQuasiNewton
extends AbstractAnytimeFunctionMinimizer<Vector, Double, DifferentiableEvaluator<? super Vector, Double, Vector>> {
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    public static final double DEFAULT_TOLERANCE = 1.0E-5;
    public static final LineMinimizer<?> DEFAULT_LINE_MINIMIZER = new LineMinimizerDerivativeBased();
    private LineMinimizer<?> lineMinimizer;
    private DirectionalVectorToDifferentiableScalarFunction lineFunction;
    private Matrix hessianInverse;
    private Vector gradient;
    private int dimensionality;

    public FunctionMinimizerQuasiNewton(LineMinimizer<?> lineMinimizer, Vector initialGuess, double tolerance, int maxIterations) {
        super(initialGuess, tolerance, maxIterations);
        this.setLineMinimizer(lineMinimizer);
    }

    @Override
    protected boolean initializeAlgorithm() {
        DifferentiableEvaluator f = (DifferentiableEvaluator)this.data;
        this.result = new DefaultInputOutputPair(((Vector)this.initialGuess).clone(), f.evaluate(this.initialGuess));
        this.gradient = (Vector)f.differentiate(this.initialGuess);
        this.lineFunction = new DirectionalVectorToDifferentiableScalarFunction(f, (Vector)this.result.getInput(), (Vector)this.gradient.scale(-1.0));
        this.dimensionality = ((Vector)this.initialGuess).getDimensionality();
        this.hessianInverse = (Matrix)MatrixFactory.getDefault().createIdentity(this.dimensionality, this.dimensionality).scale(0.5);
        return true;
    }

    @Override
    protected boolean step() {
        Vector xold = (Vector)this.result.getInput();
        this.result = this.lineMinimizer.minimizeAlongDirection(this.lineFunction, (Double)this.result.getOutput(), this.gradient);
        Vector xnew = (Vector)this.result.getInput();
        double fnew = (Double)this.result.getOutput();
        this.lineFunction.setVectorOffset(xnew);
        Vector gradientOld = this.gradient;
        this.gradient = this.lineFunction.getLastGradient() != null && this.lineFunction.getLastGradient().getInput().equals(xnew) ? this.lineFunction.getLastGradient().getOutput() : (Vector)((DifferentiableEvaluator)this.data).differentiate(xnew);
        Vector gamma = this.gradient.minus(gradientOld);
        Vector delta = xnew.minus(xold);
        if (MinimizationStoppingCriterion.convergence(xnew, fnew, this.gradient, delta, this.getTolerance())) {
            return false;
        }
        this.updateHessianInverse(this.hessianInverse, delta, gamma);
        this.lineFunction.setDirection((Vector)this.hessianInverse.times(this.gradient).scale(-1.0));
        return true;
    }

    protected abstract boolean updateHessianInverse(Matrix var1, Vector var2, Vector var3);

    @Override
    protected void cleanupAlgorithm() {
    }

    public LineMinimizer<?> getLineMinimizer() {
        return this.lineMinimizer;
    }

    public void setLineMinimizer(LineMinimizer<?> lineMinimizer) {
        this.lineMinimizer = lineMinimizer;
    }
}

