/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.math.AbstractDifferentiableUnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-06", changesNeeded=false, comments={"Fixed bug introduced into the numerical differentiation procedure.", "Made clone() call super.clone().", "Fixed the brittleness in the copy constructor."})
public class DirectionalVectorToScalarFunction
extends AbstractDifferentiableUnivariateScalarFunction {
    public static final double FORWARD_DIFFERENCE = 1.0E-5;
    private Vector vectorOffset;
    private Vector direction;
    private Evaluator<? super Vector, ? extends Double> vectorScalarFunction;
    private DefaultInputOutputPair<Double, Double> lastEvaluation;

    public DirectionalVectorToScalarFunction(Evaluator<? super Vector, ? extends Double> vectorScalarFunction, Vector vectorOffset, Vector direction) {
        this.setVectorScalarFunction(vectorScalarFunction);
        this.setVectorOffset(vectorOffset);
        this.setDirection(direction);
        this.lastEvaluation = null;
    }

    public DirectionalVectorToScalarFunction(DirectionalVectorToScalarFunction other) {
        this(ObjectUtil.cloneSmart(other.getVectorScalarFunction()), ObjectUtil.cloneSafe(other.getVectorOffset()), ObjectUtil.cloneSafe(other.getDirection()));
    }

    @Override
    public DirectionalVectorToScalarFunction clone() {
        DirectionalVectorToScalarFunction clone = (DirectionalVectorToScalarFunction)super.clone();
        clone.setVectorScalarFunction(ObjectUtil.cloneSmart(this.getVectorScalarFunction()));
        clone.setVectorOffset(ObjectUtil.cloneSafe(this.getVectorOffset()));
        clone.setDirection(ObjectUtil.cloneSafe(this.getDirection()));
        clone.lastEvaluation = null;
        return clone;
    }

    public Vector getDirection() {
        return this.direction;
    }

    public void setDirection(Vector direction) {
        this.lastEvaluation = null;
        this.direction = direction;
    }

    public Vector getVectorOffset() {
        return this.vectorOffset;
    }

    public void setVectorOffset(Vector vectorOffset) {
        this.lastEvaluation = null;
        this.vectorOffset = vectorOffset;
    }

    public Vector computeVector(double scaleFactor) {
        return (Vector)this.vectorOffset.plus(this.direction.scale(scaleFactor));
    }

    public Evaluator<? super Vector, ? extends Double> getVectorScalarFunction() {
        return this.vectorScalarFunction;
    }

    public void setVectorScalarFunction(Evaluator<? super Vector, ? extends Double> vectorScalarFunction) {
        this.vectorScalarFunction = vectorScalarFunction;
    }

    @Override
    public double evaluate(double input) {
        if (this.lastEvaluation == null) {
            Double output = this.vectorScalarFunction.evaluate(this.computeVector(input));
            this.lastEvaluation = new DefaultInputOutputPair<Double, Double>(input, output);
        } else {
            if (this.lastEvaluation.getInput() == input) {
                return this.lastEvaluation.getOutput();
            }
            Double output = this.vectorScalarFunction.evaluate(this.computeVector(input));
            this.lastEvaluation.setInput(input);
            this.lastEvaluation.setOutput(output);
        }
        return this.vectorScalarFunction.evaluate(this.computeVector(input));
    }

    @Override
    public double differentiate(double input) {
        double output;
        if (this.lastEvaluation == null) {
            output = this.evaluate(input);
            this.lastEvaluation = new DefaultInputOutputPair<Double, Double>(input, output);
        } else if (this.lastEvaluation.getInput() == input) {
            output = this.lastEvaluation.getOutput();
        } else {
            output = this.evaluate(input);
            this.lastEvaluation.setInput(input);
            this.lastEvaluation.setOutput(output);
        }
        double dx = 1.0E-5;
        double dy = this.evaluate(input + dx) - output;
        return dy / dx;
    }
}

