/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.AbstractAnytimeLineMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.minimization.line.WolfeConditions;
import gov.sandia.cognition.math.DifferentiableUnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.NumericalDifferentiator;

@PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={384, 386}, url="http://www.nrbook.com/a/bookcpdf.php")
public class LineMinimizerBacktracking
extends AbstractAnytimeLineMinimizer<Evaluator<Double, Double>> {
    public static final double STEP_MAX = 100.0;
    public static final double DEFAULT_SUFFICIENT_DECREASE = 0.5;
    public static final double DEFAULT_GEOMETRIC_DECREASE = 0.5;
    public static final boolean DEFAULT_NUMERICAL_DERIVATIVE = true;
    private double sufficientDecrease;
    private double geometricDecrease;
    private boolean numericalDerivative;
    private double stepValue;

    public LineMinimizerBacktracking() {
        this(0.5);
    }

    public LineMinimizerBacktracking(double geometricDecrease) {
        this(geometricDecrease, true);
    }

    public LineMinimizerBacktracking(double geometricDecrease, boolean numericalDerivative) {
        this(geometricDecrease, numericalDerivative, 0.5);
    }

    public LineMinimizerBacktracking(double geometricDecrease, boolean numericalDerivative, double sufficientDecrease) {
        super(null);
        this.setGeometricDecrease(geometricDecrease);
        this.setNumericalDerivative(numericalDerivative);
        this.setSufficientDecrease(sufficientDecrease);
    }

    @Override
    protected boolean initializeAlgorithm() {
        super.initializeAlgorithm();
        return this.getInitialGuess() != null;
    }

    @Override
    public boolean bracketingStep() {
        Double initialGuessFunctionValue = this.getInitialGuessFunctionValue() != null ? this.getInitialGuessFunctionValue() : (Double)((Evaluator)this.data).evaluate(this.getInitialGuess());
        Double initialGuessSlope = this.getInitialGuessSlope() != null ? this.getInitialGuessSlope() : (!this.getNumericalDerivative() && this.data instanceof DifferentiableUnivariateScalarFunction ? (Double)((DifferentiableUnivariateScalarFunction)this.data).differentiate(this.getInitialGuess()) : NumericalDifferentiator.DoubleJacobian.differentiate((Double)this.getInitialGuess(), (Evaluator)this.data));
        InputOutputSlopeTriplet initialTriplet = new InputOutputSlopeTriplet((Double)this.getInitialGuess(), initialGuessFunctionValue, initialGuessSlope);
        double slope = initialTriplet.getSlope();
        this.result = initialTriplet;
        if (Math.abs(slope) <= this.getTolerance()) {
            this.stop();
            return true;
        }
        double newtonStep = -Math.abs(initialGuessFunctionValue) / slope;
        if (Math.abs(newtonStep) > 100.0) {
            newtonStep = -Math.signum(slope) * 100.0;
        }
        this.stepValue = newtonStep;
        this.getBracket().setLowerBound(initialTriplet);
        return true;
    }

    @Override
    public boolean sectioningStep() {
        LineBracket bracket = this.getBracket();
        InputOutputSlopeTriplet initialTriplet = bracket.getLowerBound();
        double x = this.stepValue + (Double)initialTriplet.getInput();
        double fx = (Double)((Evaluator)this.data).evaluate(x);
        InputOutputSlopeTriplet trialPoint = new InputOutputSlopeTriplet(x, fx, null);
        bracket.setOtherPoint(bracket.getUpperBound());
        bracket.setUpperBound(trialPoint);
        if ((Double)this.result.getOutput() > (Double)trialPoint.getOutput()) {
            this.result = trialPoint;
        }
        if (WolfeConditions.evaluateGoldsteinCondition(initialTriplet, trialPoint, this.getSufficientDecrease())) {
            this.result = trialPoint;
            return false;
        }
        this.stepValue *= this.getGeometricDecrease();
        return Math.abs(this.stepValue) > this.getTolerance();
    }

    public double getSufficientDecrease() {
        return this.sufficientDecrease;
    }

    public void setSufficientDecrease(double sufficientDecrease) {
        if (sufficientDecrease <= 0.0 || sufficientDecrease >= 1.0) {
            throw new IllegalArgumentException("sufficientDecrease must be (0,1)");
        }
        this.sufficientDecrease = sufficientDecrease;
    }

    public double getGeometricDecrease() {
        return this.geometricDecrease;
    }

    public void setGeometricDecrease(double geometricDecrease) {
        if (geometricDecrease <= 0.0 || geometricDecrease >= 1.0) {
            throw new IllegalArgumentException("geometricDecrease must be (0,1)");
        }
        this.geometricDecrease = geometricDecrease;
    }

    public boolean getNumericalDerivative() {
        return this.numericalDerivative;
    }

    public void setNumericalDerivative(boolean numericalDerivative) {
        this.numericalDerivative = numericalDerivative;
    }
}

