/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReferences(references={@PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={26, 30}, notes={"Equation 2.5.1 and Equation 2.5.6", "Fletcher assumes the initial point has negative slope."}), @PublicationReference(author={"Wikipedia"}, title="Wolfe conditions", url="http://en.wikipedia.org/wiki/Wolfe_conditions", type=PublicationType.WebPage, year=2008)})
public class WolfeConditions
extends AbstractCloneableSerializable {
    private InputOutputSlopeTriplet originalPoint;
    private double slopeCondition;
    private double curvatureCondition;

    public WolfeConditions(InputOutputSlopeTriplet originalPoint, double slopeCondition, double curvatureCondition) {
        if (slopeCondition >= curvatureCondition) {
            throw new IllegalArgumentException("slopeCondition must be strictly less than curvatureCondition");
        }
        if (originalPoint.getSlope() >= 0.0) {
            throw new IllegalArgumentException("Can only use Wolfe conditions when original slope < 0.0");
        }
        this.setOriginalPoint(originalPoint);
        this.setSlopeCondition(slopeCondition);
        this.setCurvatureCondition(curvatureCondition);
    }

    public WolfeConditions(WolfeConditions other) {
        this(ObjectUtil.cloneSafe(other.getOriginalPoint()), other.getSlopeCondition(), other.getCurvatureCondition());
    }

    @Override
    public WolfeConditions clone() {
        WolfeConditions clone = (WolfeConditions)super.clone();
        clone.setOriginalPoint(ObjectUtil.cloneSafe(this.getOriginalPoint()));
        return clone;
    }

    public boolean evaluate(InputOutputSlopeTriplet trialPoint) {
        return this.evaluateGoldsteinCondition(trialPoint) && this.evaluateStrictCurvatureCondition(trialPoint.getSlope());
    }

    public boolean evaluateGoldsteinCondition(InputOutputPair<Double, Double> trialPoint) {
        return WolfeConditions.evaluateGoldsteinCondition(this.getOriginalPoint(), trialPoint, this.getSlopeCondition());
    }

    @PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={27}, notes={"Equation 2.5.1"})
    public static boolean evaluateGoldsteinCondition(InputOutputSlopeTriplet originalPoint, InputOutputPair<Double, Double> trialPoint, double slopeCondition) {
        double delta = trialPoint.getInput() - (Double)originalPoint.getInput();
        return trialPoint.getOutput() <= (Double)originalPoint.getOutput() + delta * slopeCondition * originalPoint.getSlope();
    }

    public boolean evaluateStrictCurvatureCondition(double trialSlope) {
        return WolfeConditions.evaluateStrictCurvatureCondition(this.getOriginalPoint().getSlope(), trialSlope, this.getCurvatureCondition());
    }

    @PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={29}, notes={"Equation 2.5.6"})
    public static boolean evaluateStrictCurvatureCondition(double originalSlope, double trialSlope, double curvatureCondition) {
        if (originalSlope >= 0.0) {
            throw new IllegalArgumentException("Original slope must be < 0.0");
        }
        return Math.abs(trialSlope) <= -curvatureCondition * originalSlope;
    }

    public InputOutputSlopeTriplet getOriginalPoint() {
        return this.originalPoint;
    }

    public void setOriginalPoint(InputOutputSlopeTriplet originalPoint) {
        this.originalPoint = originalPoint;
    }

    public double getSlopeCondition() {
        return this.slopeCondition;
    }

    public void setSlopeCondition(double slopeCondition) {
        if (slopeCondition <= 0.0 || slopeCondition >= 1.0) {
            throw new IllegalArgumentException("slopeCondition must be on the interval (0,1)");
        }
        this.slopeCondition = slopeCondition;
    }

    public double getCurvatureCondition() {
        return this.curvatureCondition;
    }

    public void setCurvatureCondition(double curvatureCondition) {
        if (curvatureCondition <= 0.0 || curvatureCondition >= 1.0) {
            throw new IllegalArgumentException("curvatureCondition must be on the interval (0,1)");
        }
        this.curvatureCondition = curvatureCondition;
    }
}

