/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line.interpolator;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.AbstractLineBracketInterpolator;
import gov.sandia.cognition.learning.function.scalar.PolynomialFunction;

public abstract class AbstractLineBracketInterpolatorPolynomial<EvaluatorType extends Evaluator<Double, Double>>
extends AbstractLineBracketInterpolator<EvaluatorType> {
    public AbstractLineBracketInterpolatorPolynomial(double tolerance) {
        super(tolerance);
    }

    @Override
    public double findMinimum(LineBracket bracket, double minx, double maxx, EvaluatorType function) {
        double bestBoundfx;
        double bestBoundx;
        double fmaxx;
        PolynomialFunction.ClosedForm interpolator = this.computePolynomial(bracket, function);
        double fstar = Double.POSITIVE_INFINITY;
        double xstar = 0.0;
        Double[] stationaryPoints = interpolator.stationaryPoints();
        for (int i = 0; i < stationaryPoints.length; ++i) {
            double f;
            double x = stationaryPoints[i];
            if (!(minx <= x) || !(x <= maxx) || !(fstar > (f = interpolator.evaluate(x)))) continue;
            fstar = f;
            xstar = x;
        }
        double fminx = interpolator.evaluate(minx);
        if (fminx < (fmaxx = interpolator.evaluate(maxx))) {
            bestBoundx = minx;
            bestBoundfx = fminx;
        } else {
            bestBoundx = maxx;
            bestBoundfx = fmaxx;
        }
        double bestx = fstar <= bestBoundfx ? xstar : bestBoundx;
        return bestx;
    }

    public abstract PolynomialFunction.ClosedForm computePolynomial(LineBracket var1, EvaluatorType var2);
}

