/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.nearest;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.learning.algorithm.nearest.AbstractNearestNeighbor;
import gov.sandia.cognition.learning.algorithm.nearest.KNearestNeighbor;
import gov.sandia.cognition.math.DivergenceFunction;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Summarizer;
import java.util.Collection;

public abstract class AbstractKNearestNeighbor<InputType, OutputType>
extends AbstractNearestNeighbor<InputType, OutputType>
implements KNearestNeighbor<InputType, OutputType> {
    private int k;
    private Summarizer<? super OutputType, ? extends OutputType> averager;

    public AbstractKNearestNeighbor(int k, DivergenceFunction<? super InputType, ? super InputType> divergenceFunction, Summarizer<? super OutputType, ? extends OutputType> averager) {
        super(divergenceFunction);
        this.setK(k);
        this.setAverager(averager);
    }

    @Override
    public AbstractKNearestNeighbor<InputType, OutputType> clone() {
        AbstractKNearestNeighbor clone = (AbstractKNearestNeighbor)super.clone();
        clone.setAverager(ObjectUtil.cloneSmart(this.getAverager()));
        return clone;
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public void setK(int k) {
        if (k <= 0) {
            throw new IllegalArgumentException("Number of neighbors must be greater than zero");
        }
        this.k = k;
    }

    @Override
    public Summarizer<? super OutputType, ? extends OutputType> getAverager() {
        return this.averager;
    }

    @Override
    public void setAverager(Summarizer<? super OutputType, ? extends OutputType> averager) {
        this.averager = averager;
    }

    protected abstract Collection<OutputType> computeNeighborhood(InputType var1);

    @Override
    public OutputType evaluate(InputType input) {
        Collection<OutputType> neighbors = this.computeNeighborhood(input);
        if (this.getK() == 1) {
            return CollectionUtil.getFirst(neighbors);
        }
        return this.getAverager().summarize(neighbors);
    }
}

