/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.nearest;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.algorithm.nearest.AbstractKNearestNeighbor;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.distance.EuclideanDistanceMetric;
import gov.sandia.cognition.math.DivergenceFunction;
import gov.sandia.cognition.math.Metric;
import gov.sandia.cognition.math.geometry.KDTree;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.Summarizer;
import java.util.ArrayList;
import java.util.Collection;

@PublicationReference(author={"Wikipedia"}, title="k-nearest neighbor algorithm", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/K-nearest_neighbor_algorithm")
public class KNearestNeighborKDTree<InputType extends Vectorizable, OutputType>
extends AbstractKNearestNeighbor<InputType, OutputType>
implements Evaluator<InputType, OutputType> {
    private KDTree<InputType, OutputType, InputOutputPair<? extends InputType, OutputType>> data;

    public KNearestNeighborKDTree() {
        this(1, null, null, null);
    }

    public KNearestNeighborKDTree(int k, KDTree<InputType, OutputType, InputOutputPair<? extends InputType, OutputType>> data, Metric<? super InputType> distanceFunction, Summarizer<? super OutputType, ? extends OutputType> averager) {
        super(k, distanceFunction, averager);
        this.setData(data);
    }

    @Override
    public KNearestNeighborKDTree<InputType, OutputType> clone() {
        KNearestNeighborKDTree clone = (KNearestNeighborKDTree)super.clone();
        clone.setData((KDTree)ObjectUtil.cloneSafe(this.getData()));
        return clone;
    }

    public Metric<? super InputType> getDivergenceFunction() {
        return (Metric)super.getDivergenceFunction();
    }

    @Override
    public void setDivergenceFunction(DivergenceFunction<? super InputType, ? super InputType> divergenceFunction) {
        this.setDivergenceFunction((Metric)divergenceFunction);
    }

    public void setDivergenceFunction(Metric<? super InputType> divergenceFunction) {
        super.setDivergenceFunction(divergenceFunction);
    }

    public KDTree<InputType, OutputType, InputOutputPair<? extends InputType, OutputType>> getData() {
        return this.data;
    }

    public void setData(KDTree<InputType, OutputType, InputOutputPair<? extends InputType, OutputType>> data) {
        this.data = data;
    }

    @Override
    protected Collection<OutputType> computeNeighborhood(InputType key) {
        Collection neighbors = ((KDTree)this.getData()).findNearest(key, this.getK(), this.getDivergenceFunction());
        ArrayList outputs = new ArrayList(neighbors.size());
        for (InputOutputPair neighbor : neighbors) {
            outputs.add(neighbor.getSecond());
        }
        return outputs;
    }

    public void rebalance() {
        this.setData(((KDTree)this.getData()).reblanace());
    }

    public static class Learner<InputType extends Vectorizable, OutputType>
    extends KNearestNeighborKDTree<InputType, OutputType>
    implements SupervisedBatchLearner<InputType, OutputType, KNearestNeighborKDTree<InputType, OutputType>> {
        public Learner() {
            this((Summarizer<OutputType, OutputType>)null);
        }

        public Learner(Summarizer<? super OutputType, ? extends OutputType> averager) {
            this(1, EuclideanDistanceMetric.INSTANCE, (Summarizer<? extends OutputType, ? extends OutputType>)averager);
        }

        public Learner(int k, Metric<? super Vectorizable> divergenceFunction, Summarizer<? super OutputType, ? extends OutputType> averager) {
            super(k, null, divergenceFunction, averager);
        }

        @Override
        public KNearestNeighborKDTree<InputType, OutputType> learn(Collection<? extends InputOutputPair<? extends InputType, OutputType>> data) {
            AbstractKNearestNeighbor clone = this.clone();
            KDTree tree = KDTree.createBalanced(data);
            ((KNearestNeighborKDTree)clone).setData(tree);
            return clone;
        }
    }
}

