/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.pca;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.pca.PrincipalComponentsAnalysis;
import gov.sandia.cognition.learning.algorithm.pca.PrincipalComponentsAnalysisFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Minor change to javadoc.", "Looks fine."})
public abstract class AbstractPrincipalComponentsAnalysis
extends AbstractCloneableSerializable
implements PrincipalComponentsAnalysis {
    private int numComponents;
    private PrincipalComponentsAnalysisFunction result;

    public AbstractPrincipalComponentsAnalysis(int numComponents, PrincipalComponentsAnalysisFunction result) {
        this.setNumComponents(numComponents);
        this.setResult(result);
    }

    @Override
    public AbstractPrincipalComponentsAnalysis clone() {
        AbstractPrincipalComponentsAnalysis clone = (AbstractPrincipalComponentsAnalysis)super.clone();
        clone.setResult(ObjectUtil.cloneSafe(this.getResult()));
        return clone;
    }

    @Override
    public int getNumComponents() {
        return this.numComponents;
    }

    public void setNumComponents(int numComponents) {
        if (numComponents <= 0) {
            throw new IllegalArgumentException("Number of components must be > 0");
        }
        this.numComponents = numComponents;
    }

    @Override
    public PrincipalComponentsAnalysisFunction getResult() {
        return this.result;
    }

    protected void setResult(PrincipalComponentsAnalysisFunction result) {
        this.result = result;
    }
}

