/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.pca;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.function.vector.MatrixMultiplyVectorFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-09-02", changesNeeded=false, comments={"Added default constructor, minor changes to javadoc and clone() annotation", "Looks fine."})
public class PrincipalComponentsAnalysisFunction
extends AbstractCloneableSerializable
implements VectorFunction {
    private Vector mean;
    private MatrixMultiplyVectorFunction dimensionReducer;

    public PrincipalComponentsAnalysisFunction() {
        this(null, null);
    }

    public PrincipalComponentsAnalysisFunction(Vector mean, MatrixMultiplyVectorFunction dimensionReducer) {
        this.setMean(mean);
        this.setDimensionReducer(dimensionReducer);
    }

    @Override
    public PrincipalComponentsAnalysisFunction clone() {
        PrincipalComponentsAnalysisFunction clone = (PrincipalComponentsAnalysisFunction)super.clone();
        clone.setMean(ObjectUtil.cloneSafe(this.getMean()));
        clone.setDimensionReducer(ObjectUtil.cloneSafe(this.getDimensionReducer()));
        return clone;
    }

    @Override
    public Vector evaluate(Vector input) {
        Vector delta = input.minus(this.getMean());
        return this.getDimensionReducer().evaluate(delta);
    }

    public int getInputDimensionality() {
        return this.getDimensionReducer().getInternalMatrix().getNumColumns();
    }

    public int getOutputDimensionality() {
        return this.getDimensionReducer().getInternalMatrix().getNumRows();
    }

    public Vector getMean() {
        return this.mean;
    }

    public void setMean(Vector mean) {
        this.mean = mean;
    }

    public MatrixMultiplyVectorFunction getDimensionReducer() {
        return this.dimensionReducer;
    }

    public void setDimensionReducer(MatrixMultiplyVectorFunction dimensionReducer) {
        this.dimensionReducer = dimensionReducer;
    }
}

