/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.pca;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.pca.AbstractPrincipalComponentsAnalysis;
import gov.sandia.cognition.learning.algorithm.pca.PrincipalComponentsAnalysisFunction;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.function.vector.MatrixMultiplyVectorFunction;
import gov.sandia.cognition.math.MultivariateStatisticsUtil;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.decomposition.EigenvectorPowerIteration;
import java.util.ArrayList;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Minor changes to javadoc.", "Looks fine."})
public class ThinSingularValueDecomposition
extends AbstractPrincipalComponentsAnalysis {
    public ThinSingularValueDecomposition(int numComponents) {
        this(numComponents, null);
    }

    public ThinSingularValueDecomposition(int numComponents, PrincipalComponentsAnalysisFunction learned) {
        super(numComponents, learned);
    }

    @Override
    public PrincipalComponentsAnalysisFunction learn(Collection<Vector> data) {
        PrincipalComponentsAnalysisFunction pca = ThinSingularValueDecomposition.learn(data, this.getNumComponents());
        this.setResult(pca);
        return pca;
    }

    public static PrincipalComponentsAnalysisFunction learn(Collection<Vector> data, int numComponents) {
        Vector mean = MultivariateStatisticsUtil.computeMean(data);
        ArrayList<Vector> dataArray = new ArrayList<Vector>(data.size());
        for (Vector x : data) {
            dataArray.add(x.minus(mean));
        }
        Matrix XXt = DatasetUtil.computeOuterProductDataMatrix(dataArray);
        ArrayList<Vector> components = EigenvectorPowerIteration.estimateEigenvectors(XXt, numComponents);
        Matrix V = MatrixFactory.getDefault().createMatrix(components.size(), mean.getDimensionality());
        for (int i = 0; i < components.size(); ++i) {
            V.setRow(i, components.get(i));
        }
        return new PrincipalComponentsAnalysisFunction(mean, new MatrixMultiplyVectorFunction(V));
    }
}

