/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.AbstractKernelizableBinaryCategorizerOnlineLearner;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.KernelUtil;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.util.ArgumentChecker;

@PublicationReference(author={"Shai Shalev-Shwartz", "Yoram Singer"}, title="A New Perspective on an Old Perceptron Algorithm", year=2005, type=PublicationType.Conference, publication="Conference on Learning Theory", pages={815, 824}, url="http://www.springerlink.com/index/hr4hrbyajy0y8a7l.pdf")
public class Ballseptron
extends AbstractKernelizableBinaryCategorizerOnlineLearner {
    public static final double DEFAULT_RADIUS = 0.1;
    protected double radius;

    public Ballseptron() {
        this(0.1);
    }

    public Ballseptron(double radius) {
        this.setRadius(radius);
    }

    @Override
    public void update(LinearBinaryCategorizer target, Vector input, boolean label) {
        Vector weights = target.getWeights();
        if (weights == null) {
            weights = this.getVectorFactory().createVector(input.getDimensionality());
            target.setWeights(weights);
        }
        double prediction = target.evaluateAsDouble(input);
        double actual = label ? 1.0 : -1.0;
        double margin = prediction * actual;
        boolean error = false;
        if (margin <= 0.0) {
            error = true;
        } else {
            double weightNorm = weights.norm2();
            if (margin / weightNorm <= this.getRadius()) {
                double scale = 1.0 - this.getRadius() / weightNorm;
                weights.scaleEquals(scale);
                error = true;
            }
        }
        if (error) {
            if (label) {
                weights.plusEquals(input);
            } else {
                weights.minusEquals(input);
            }
        }
    }

    @Override
    public <InputType> void update(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean label) {
        double actual;
        double prediction = target.evaluateAsDouble(input);
        double margin = prediction * (actual = label ? 1.0 : -1.0);
        if (margin <= 0.0) {
            target.add(input, actual);
        } else {
            double weightNorm = KernelUtil.norm2(target);
            if (margin / weightNorm <= this.getRadius()) {
                double scale = 1.0 - this.getRadius() / weightNorm;
                KernelUtil.scaleEquals(target, scale);
                target.add(input, actual);
            }
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        ArgumentChecker.assertIsPositive("radius", radius);
        this.radius = radius;
    }
}

