/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.AbstractLinearCombinationOnlineLearner;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.util.ArgumentChecker;

@PublicationReference(title="Online Passive-Aggressive Algorithms", author={"Koby Crammer", "Ofer Dekel", "Joseph Keshet", "Shai Shalev-Shwartz", "Yoram Singer"}, year=2006, type=PublicationType.Journal, publication="Journal of Machine Learning Research", pages={551, 585}, url="http://portal.acm.org/citation.cfm?id=1248566")
public class OnlinePassiveAggressivePerceptron
extends AbstractLinearCombinationOnlineLearner {
    public static final boolean DEFAULT_UPDATE_BIAS = false;

    public OnlinePassiveAggressivePerceptron() {
        this(VectorFactory.getDefault());
    }

    public OnlinePassiveAggressivePerceptron(VectorFactory<?> vectorFactory) {
        super(false, vectorFactory);
    }

    protected double computeUpdate(double actual, double predicted, double loss, double inputNorm2Squared) {
        if (inputNorm2Squared == 0.0) {
            return 0.0;
        }
        return loss / inputNorm2Squared;
    }

    @Override
    public double computeUpdate(LinearBinaryCategorizer target, Vector input, boolean actualCategory, double predicted) {
        double actual = actualCategory ? 1.0 : -1.0;
        double loss = 1.0 - actual * predicted;
        if (loss <= 0.0) {
            return 0.0;
        }
        double inputNorm2Squared = input.norm2Squared();
        return this.computeUpdate(actual, predicted, loss, inputNorm2Squared);
    }

    @Override
    public <InputType> double computeUpdate(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean actualCategory, double predicted) {
        double actual = actualCategory ? 1.0 : -1.0;
        double loss = 1.0 - actual * predicted;
        if (loss <= 0.0) {
            return 0.0;
        }
        double norm = target.getKernel().evaluate(input, input);
        return this.computeUpdate(actual, predicted, loss, norm);
    }

    public static class QuadraticSoftMargin
    extends AbstractSoftMargin {
        public QuadraticSoftMargin() {
            this(0.001);
        }

        public QuadraticSoftMargin(double aggressiveness) {
            this(aggressiveness, VectorFactory.getDefault());
        }

        public QuadraticSoftMargin(double aggressiveness, VectorFactory<?> vectorFactory) {
            super(aggressiveness, vectorFactory);
        }

        @Override
        protected double computeUpdate(double actual, double predicted, double loss, double inputNorm2Squared) {
            return loss / (inputNorm2Squared + 1.0 / (2.0 * this.aggressiveness));
        }
    }

    public static class LinearSoftMargin
    extends AbstractSoftMargin {
        public LinearSoftMargin() {
            this(0.001);
        }

        public LinearSoftMargin(double aggressiveness) {
            this(aggressiveness, VectorFactory.getDefault());
        }

        public LinearSoftMargin(double aggressiveness, VectorFactory<?> vectorFactory) {
            super(aggressiveness, vectorFactory);
        }

        @Override
        protected double computeUpdate(double actual, double predicted, double loss, double inputNorm2Squared) {
            if (inputNorm2Squared == 0.0) {
                return 0.0;
            }
            return Math.min(this.aggressiveness, loss / inputNorm2Squared);
        }
    }

    public static abstract class AbstractSoftMargin
    extends OnlinePassiveAggressivePerceptron {
        public static final double DEFAULT_AGGRESSIVENESS = 0.001;
        protected double aggressiveness;

        public AbstractSoftMargin() {
            this(0.001);
        }

        public AbstractSoftMargin(double aggressiveness) {
            this(aggressiveness, VectorFactory.getDefault());
        }

        public AbstractSoftMargin(double aggressiveness, VectorFactory<?> vectorFactory) {
            super(vectorFactory);
            this.setAggressiveness(aggressiveness);
        }

        public double getAggressiveness() {
            return this.aggressiveness;
        }

        public void setAggressiveness(double aggressiveness) {
            ArgumentChecker.assertIsPositive("aggressiveness", aggressiveness);
            this.aggressiveness = aggressiveness;
        }
    }
}

