/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.AbstractLinearCombinationOnlineLearner;
import gov.sandia.cognition.learning.algorithm.perceptron.OnlinePerceptron;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.util.ArgumentChecker;

@PublicationReference(author={"Giovanni Cavallanti", "Nicolo Cesa-Bianchi", "Claudio Gentile"}, title="Tracking the best hyperplane with a simple budget Perceptron", year=2007, type=PublicationType.Journal, publication="Machine Learning", pages={143, 167}, url="http://www.springerlink.com/index/H40NV525LX161227.pdf")
public class OnlineShiftingPerceptron
extends AbstractLinearCombinationOnlineLearner {
    public static final boolean DEFAULT_UPDATE_BIAS = false;
    public static final double DEFAULT_LAMBDA = 0.001;
    protected double lambda;

    public OnlineShiftingPerceptron() {
        this(0.001);
    }

    public OnlineShiftingPerceptron(double lambda) {
        this(lambda, VectorFactory.getDefault());
    }

    public OnlineShiftingPerceptron(double lambda, VectorFactory<?> vectorFactory) {
        super(false, vectorFactory);
        this.setLambda(lambda);
    }

    @Override
    public LinearBinaryCategorizer createInitialLearnedObject() {
        return new LinearResult();
    }

    @Override
    public double computeUpdate(LinearBinaryCategorizer target, Vector input, boolean label, double predicted) {
        return OnlinePerceptron.computeUpdate(label, predicted);
    }

    @Override
    public <InputType> double computeUpdate(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean label, double predicted) {
        return OnlinePerceptron.computeUpdate(label, predicted);
    }

    @Override
    protected double computeDecay(LinearBinaryCategorizer target, Vector input, boolean actualCategory, double predicted, double update) {
        double actual = actualCategory ? 1.0 : -1.0;
        double margin = actual * predicted;
        if (margin > 0.0) {
            return 1.0;
        }
        LinearResult result = (LinearResult)target;
        long errorCount = result.errorCount++;
        double lambdaK = this.lambda / (this.lambda + (double)errorCount);
        return 1.0 - lambdaK;
    }

    @Override
    protected <InputType> double computeDecay(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean actualCategory, double predicted, double update) {
        double actual = actualCategory ? 1.0 : -1.0;
        double margin = actual * predicted;
        if (margin > 0.0) {
            return 1.0;
        }
        long errorCount = target.getExamples().size();
        double lambdaK = this.lambda / (this.lambda + (double)errorCount);
        return 1.0 - lambdaK;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        ArgumentChecker.assertIsPositive("lambda", lambda);
        this.lambda = lambda;
    }

    public static class LinearResult
    extends LinearBinaryCategorizer {
        protected long errorCount;

        public LinearResult() {
            this.setErrorCount(0L);
        }

        public long getErrorCount() {
            return this.errorCount;
        }

        public void setErrorCount(long errorCount) {
            this.errorCount = errorCount;
        }
    }
}

