/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron.kernel;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.kernel.AbstractOnlineBudgetedKernelBinaryCategorizerLearner;
import gov.sandia.cognition.learning.algorithm.perceptron.kernel.OnlineKernelPerceptron;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.Randomized;
import java.util.Random;

@PublicationReference(author={"Nicolo Cesa-Bianchi", "Claudio Gentile"}, title="Tracking the Best Hyperplane with a Simple Budget Perceptron", year=2006, type=PublicationType.Conference, publication="Conference on Learning Theory", pages={483, 498}, url="http://www.springerlink.com/index/d65th427143p0532.pdf")
public class OnlineKernelRandomizedBudgetPerceptron<InputType>
extends AbstractOnlineBudgetedKernelBinaryCategorizerLearner<InputType>
implements Randomized {
    protected Random random;

    public OnlineKernelRandomizedBudgetPerceptron() {
        this(null, 100, new Random());
    }

    public OnlineKernelRandomizedBudgetPerceptron(Kernel<? super InputType> kernel, int budget, Random random) {
        super(kernel, budget);
        this.setRandom(random);
    }

    @Override
    public void update(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean output) {
        OnlineKernelPerceptron.update(target, input, output, true);
        for (int size = target.getExampleCount(); size > this.getBudget(); --size) {
            int randomIndex = this.getRandom().nextInt(size);
            DefaultWeightedValue<InputType> entry = target.remove(randomIndex);
            target.setBias(target.getBias() - entry.getWeight());
        }
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public void setRandom(Random random) {
        this.random = random;
    }
}

