/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron.kernel;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.kernel.AbstractOnlineKernelBinaryCategorizerLearner;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.util.ArgumentChecker;
import gov.sandia.cognition.util.DefaultWeightedValue;

@PublicationReference(author={"Francesco Orabona", "Joseph Keshet", "Barbara Caputo"}, title="Bounded Kernel-Based Online Learning", year=2009, type=PublicationType.Journal, publication="Journal of Machine Learning Research", pages={2643, 2666}, url="http://portal.acm.org/citation.cfm?id=1755875")
public class Projectron<InputType>
extends AbstractOnlineKernelBinaryCategorizerLearner<InputType> {
    public static final double DEFAULT_ETA = 0.01;
    protected double eta;

    public Projectron() {
        this(null);
    }

    public Projectron(Kernel<? super InputType> kernel) {
        this(kernel, 0.01);
    }

    public Projectron(Kernel<? super InputType> kernel, double eta) {
        super(kernel);
        this.setEta(eta);
    }

    @Override
    public void update(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean label) {
        double actual;
        double prediction = target.evaluateAsDouble(input);
        double margin = prediction * (actual = label ? 1.0 : -1.0);
        if (!this.shouldUpdate(margin)) {
            return;
        }
        int size = target.getExampleCount();
        Kernel<InputType> kernel = target.getKernel();
        Matrix K = MatrixFactory.getDenseDefault().createMatrix(size, size);
        Vector k = VectorFactory.getDenseDefault().createVector(size);
        for (int i = 0; i < size; ++i) {
            InputType xI = target.get(i).getValue();
            k.setElement(i, kernel.evaluate(input, xI));
            K.setElement(i, i, kernel.evaluate(xI, xI));
            for (int j = i + 1; j < size; ++j) {
                InputType xJ = target.get(j).getValue();
                double value = kernel.evaluate(xI, xJ);
                K.setElement(i, j, value);
                K.setElement(j, i, value);
            }
        }
        Vector d = K.inverse().times(k);
        double kernelInputInput = kernel.evaluate(input, input);
        double deltaSquared = kernelInputInput - k.dotProduct(d);
        double delta = Math.sqrt(Math.max(0.0, deltaSquared));
        this.applyUpdate(target, input, actual, margin, kernelInputInput, delta, d);
    }

    protected boolean shouldUpdate(double margin) {
        return margin <= 0.0;
    }

    protected void applyUpdate(DefaultKernelBinaryCategorizer<InputType> target, InputType input, double actual, double margin, double kernelInputInput, double delta, Vector d) {
        if (delta <= this.getEta()) {
            int size = target.getExampleCount();
            for (int i = 0; i < size; ++i) {
                DefaultWeightedValue<InputType> support = target.get(i);
                double oldWeight = support.getWeight();
                double newWeight = oldWeight + d.getElement(i) * actual;
                support.setWeight(newWeight);
            }
        } else {
            target.add(input, actual);
        }
    }

    public double getEta() {
        return this.eta;
    }

    public void setEta(double eta) {
        ArgumentChecker.assertIsNonNegative("eta", eta);
        this.eta = eta;
    }

    @PublicationReference(author={"Francesco Orabona", "Joseph Keshet", "Barbara Caputo"}, title="Bounded Kernel-Based Online Learning", year=2009, type=PublicationType.Journal, publication="Journal of Machine Learning Research", pages={2643, 2666}, url="http://portal.acm.org/citation.cfm?id=1755875", notes={"This is the Projectron++."})
    public static class LinearSoftMargin<InputType>
    extends Projectron<InputType> {
        public LinearSoftMargin() {
            this(null);
        }

        public LinearSoftMargin(Kernel<? super InputType> kernel) {
            this(kernel, 0.01);
        }

        public LinearSoftMargin(Kernel<? super InputType> kernel, double eta) {
            super(kernel, eta);
        }

        @Override
        protected boolean shouldUpdate(double margin) {
            return margin <= 1.0;
        }

        @Override
        protected void applyUpdate(DefaultKernelBinaryCategorizer<InputType> target, InputType input, double actual, double margin, double kernelInputInput, double delta, Vector d) {
            if (margin <= 0.0) {
                super.applyUpdate(target, input, actual, margin, kernelInputInput, delta, d);
            } else if (margin <= 1.0) {
                int size = target.getExampleCount();
                double loss = 1.0 - margin;
                if (loss >= delta / this.eta) {
                    double norm = Math.max(0.0, kernelInputInput - delta);
                    double tau = Math.min(1.0, Math.min(loss / norm, 2.0 * (loss - delta / this.eta) / norm));
                    for (int i = 0; i < size; ++i) {
                        DefaultWeightedValue<InputType> support = target.get(i);
                        double oldWeight = support.getWeight();
                        double newWeight = oldWeight + tau * d.getElement(i) * actual;
                        support.setWeight(newWeight);
                    }
                }
            }
        }
    }
}

