/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.regression;

import gov.sandia.cognition.algorithm.AnytimeAlgorithmWrapper;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.FunctionMinimizer;
import gov.sandia.cognition.learning.algorithm.regression.ParameterCostMinimizer;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.cost.DifferentiableCostFunction;
import gov.sandia.cognition.learning.function.cost.ParallelizedCostFunctionContainer;
import gov.sandia.cognition.learning.function.cost.SumSquaredErrorCostFunction;
import gov.sandia.cognition.learning.function.cost.SupervisedCostFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorizableVectorFunction;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.NamedValue;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Collection;

public abstract class AbstractMinimizerBasedParameterCostMinimizer<ResultType extends VectorizableVectorFunction, EvaluatorType extends Evaluator<? super Vector, ? extends Double>>
extends AnytimeAlgorithmWrapper<ResultType, FunctionMinimizer<Vector, Double, ? super EvaluatorType>>
implements ParameterCostMinimizer<ResultType> {
    private ResultType objectToOptimize;
    private ResultType result;
    private SupervisedCostFunction<Vector, Vector> costFunction;
    public static final DifferentiableCostFunction DEFAULT_COST_FUNCTION = new ParallelizedCostFunctionContainer(new SumSquaredErrorCostFunction());

    public AbstractMinimizerBasedParameterCostMinimizer(FunctionMinimizer<Vector, Double, ? super EvaluatorType> algorithm) {
        this(algorithm, DEFAULT_COST_FUNCTION);
    }

    public AbstractMinimizerBasedParameterCostMinimizer(FunctionMinimizer<Vector, Double, ? super EvaluatorType> algorithm, SupervisedCostFunction<Vector, Vector> costFunction) {
        super(algorithm);
        this.setCostFunction(costFunction);
    }

    @Override
    public AbstractMinimizerBasedParameterCostMinimizer<ResultType, EvaluatorType> clone() {
        AbstractMinimizerBasedParameterCostMinimizer clone = (AbstractMinimizerBasedParameterCostMinimizer)super.clone();
        clone.setObjectToOptimize((VectorizableVectorFunction)ObjectUtil.cloneSafe(this.getObjectToOptimize()));
        clone.setResult((VectorizableVectorFunction)ObjectUtil.cloneSafe(this.getResult()));
        clone.setCostFunction((SupervisedCostFunction)ObjectUtil.cloneSafe(this.getCostFunction()));
        return clone;
    }

    public abstract EvaluatorType createInternalFunction();

    @Override
    public ResultType getObjectToOptimize() {
        return this.objectToOptimize;
    }

    @Override
    public void setObjectToOptimize(ResultType objectToOptimize) {
        this.objectToOptimize = objectToOptimize;
    }

    @Override
    public ResultType getResult() {
        return this.result;
    }

    public void setResult(ResultType result) {
        this.result = result;
    }

    @Override
    public ResultType learn(Collection<? extends InputOutputPair<? extends Vector, Vector>> data) {
        this.getCostFunction().setCostParameters(data);
        this.setResult(this.getObjectToOptimize().clone());
        Vector parameters = this.getResult().convertToVector();
        ((FunctionMinimizer)this.getAlgorithm()).setInitialGuess(parameters);
        EvaluatorType internalFunction = this.createInternalFunction();
        InputOutputPair bestParameters = ((FunctionMinimizer)this.getAlgorithm()).learn(internalFunction);
        this.getResult().convertFromVector((Vector)bestParameters.getInput());
        return (ResultType)this.getResult();
    }

    @Override
    public SupervisedCostFunction<Vector, Vector> getCostFunction() {
        return this.costFunction;
    }

    public void setCostFunction(SupervisedCostFunction<Vector, Vector> costFunction) {
        this.costFunction = costFunction;
    }

    public NamedValue<Double> getPerformance() {
        Double performance = ((FunctionMinimizer)this.getAlgorithm()).getResult() != null ? (Double)((InputOutputPair)((FunctionMinimizer)this.getAlgorithm()).getResult()).getSecond() : null;
        return new DefaultNamedValue<Double>("cost", performance);
    }
}

