/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.regression;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.gradient.GradientDescendable;
import gov.sandia.cognition.learning.algorithm.regression.LeastSquaresEstimator;
import gov.sandia.cognition.learning.function.cost.SumSquaredErrorCostFunction;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import java.util.Collection;

@PublicationReferences(references={@PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={685, 687}, notes={"Section 15.5"}, url="http://www.nrbook.com/a/bookcpdf.php"), @PublicationReference(author={"Wikipedia"}, title="Levenberg-Marquardt algorithm", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/Levenberg-Marquardt_algorithm")})
public class LevenbergMarquardtEstimation
extends LeastSquaresEstimator {
    public static final double DEFAULT_DAMPING = 1.0;
    public static final double DEFAULT_DAMPING_DIVISOR = 10.0;
    public static final int DEFAULT_MAX_ITERATIONS_WITHOUT_IMPROVEMENT = 4;
    private int iterationsWithoutImprovement;
    private int maxIterationsWithoutImprovement;
    private double dampingFactor;
    private double dampingFactorDivisor;
    private Vector bestParameters;
    private SumSquaredErrorCostFunction.Cache bestParametersCost;

    public LevenbergMarquardtEstimation() {
        this(1.0, 10.0, 1000, 4, 1.0E-7);
    }

    public LevenbergMarquardtEstimation(double dampingFactor, double dampingFactorDivisor, int maxIterations, int maxIterationsWithoutImprovement, double tolerance) {
        super(maxIterations, tolerance);
        this.setDampingFactor(dampingFactor);
        this.setDampingFactorDivisor(dampingFactorDivisor);
        this.setMaxIterationsWithoutImprovement(maxIterationsWithoutImprovement);
    }

    @Override
    protected boolean initializeAlgorithm() {
        this.setResult(((GradientDescendable)this.getObjectToOptimize()).clone());
        this.setIterationsWithoutImprovement(0);
        this.bestParameters = ((GradientDescendable)this.getResult()).convertToVector();
        this.bestParametersCost = SumSquaredErrorCostFunction.Cache.compute((GradientDescendable)this.getResult(), (Collection)this.getData());
        this.setResultCost(this.bestParametersCost.parameterCost);
        return true;
    }

    @Override
    protected boolean step() {
        Matrix JtJpI = (Matrix)this.bestParametersCost.JtJ.scale(-1.0);
        Vector Jte = this.bestParametersCost.Jte;
        int M = JtJpI.getNumRows();
        for (int i = 0; i < M; ++i) {
            double v = JtJpI.getElement(i, i);
            JtJpI.setElement(i, i, v - this.getDampingFactor());
        }
        Vector trialParameters = JtJpI.solve(Jte);
        trialParameters.plusEquals(this.bestParameters);
        ((GradientDescendable)this.getResult()).convertFromVector(trialParameters);
        SumSquaredErrorCostFunction.Cache trialCost = SumSquaredErrorCostFunction.Cache.compute((GradientDescendable)this.getResult(), (Collection)this.getData());
        if (trialCost.parameterCost < this.bestParametersCost.parameterCost) {
            this.iterationsWithoutImprovement = 0;
            this.dampingFactor /= this.dampingFactorDivisor;
            this.bestParameters = trialParameters;
            double delta = trialParameters.norm2() * (this.bestParametersCost.parameterCost - trialCost.parameterCost);
            this.bestParameters = trialParameters;
            this.bestParametersCost = trialCost;
            this.setResultCost(this.bestParametersCost.parameterCost);
            if (delta < this.getTolerance()) {
                return false;
            }
        } else {
            this.dampingFactor *= this.dampingFactorDivisor;
            ++this.iterationsWithoutImprovement;
        }
        return this.iterationsWithoutImprovement <= this.getMaxIterationsWithoutImprovement();
    }

    @Override
    protected void cleanupAlgorithm() {
        ((GradientDescendable)this.getResult()).convertFromVector(this.bestParameters);
    }

    public int getIterationsWithoutImprovement() {
        return this.iterationsWithoutImprovement;
    }

    public void setIterationsWithoutImprovement(int iterationsWithoutImprovement) {
        this.iterationsWithoutImprovement = iterationsWithoutImprovement;
    }

    public int getMaxIterationsWithoutImprovement() {
        return this.maxIterationsWithoutImprovement;
    }

    public void setMaxIterationsWithoutImprovement(int maxIterationsWithoutImprovement) {
        this.maxIterationsWithoutImprovement = maxIterationsWithoutImprovement;
    }

    public double getDampingFactor() {
        return this.dampingFactor;
    }

    public void setDampingFactor(double dampingFactor) {
        this.dampingFactor = dampingFactor;
    }

    public double getDampingFactorDivisor() {
        return this.dampingFactorDivisor;
    }

    public void setDampingFactorDivisor(double dampingFactorDivisor) {
        this.dampingFactorDivisor = dampingFactorDivisor;
    }
}

